"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _app_logic = require("../../app_logic");
var _layout = require("../../components/layout");
var _constants = require("../../constants");
var _routes = require("../../routes");
var _not_found = require("../not_found");
var _display_settings = require("./components/display_settings");
var _overview = require("./components/overview");
var _schema = require("./components/schema");
var _schema_change_errors = require("./components/schema/schema_change_errors");
var _source_content = require("./components/source_content");
var _source_settings = require("./components/source_settings");
var _synchronization = require("./components/synchronization");
var _source_logic = require("./source_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceRouter = () => {
  const {
    sourceId
  } = (0, _reactRouterDom.useParams)();
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    initializeSource,
    resetSourceState
  } = (0, _kea.useActions)(_source_logic.SourceLogic);
  const {
    contentSource,
    dataLoading
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  (0, _react.useEffect)(() => {
    initializeSource(sourceId);
  }, [pathname]);
  (0, _react.useEffect)(() => {
    return resetSourceState;
  }, []);
  if (dataLoading) {
    return isOrganization ? /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
      isLoading: true
    }) : /*#__PURE__*/_react.default.createElement(_layout.PersonalDashboardLayout, {
      isLoading: true
    });
  }
  const {
    serviceType
  } = contentSource;
  const isCustomSource = serviceType === _constants.CUSTOM_SERVICE_TYPE;
  const showSynchronization = !isCustomSource && isOrganization;
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getContentSourcePath)(_routes.SOURCE_DETAILS_PATH, sourceId, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_overview.Overview, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getContentSourcePath)(_routes.SOURCE_CONTENT_PATH, sourceId, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_source_content.SourceContent, null)), showSynchronization && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: (0, _routes.getContentSourcePath)(_routes.SOURCE_SYNCHRONIZATION_PATH, sourceId, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_synchronization.SynchronizationRouter, null)), isCustomSource && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getContentSourcePath)(_routes.SOURCE_SCHEMAS_PATH, sourceId, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_schema.Schema, null)), isCustomSource && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getSourcesPath)(_routes.REINDEX_JOB_PATH, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_schema_change_errors.SchemaChangeErrors, null)), isCustomSource && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: (0, _routes.getContentSourcePath)(_routes.SOURCE_DISPLAY_SETTINGS_PATH, sourceId, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_display_settings.DisplaySettingsRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getContentSourcePath)(_routes.SOURCE_SETTINGS_PATH, sourceId, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_source_settings.SourceSettings, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, {
    isOrganization: isOrganization,
    pageChrome: [_constants.NAV.SOURCES]
  })));
};
exports.SourceRouter = SourceRouter;