"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSynchronizationSubNav = void 0;
var _kea = require("kea");
var _layout = require("../../../../../shared/layout");
var _constants = require("../../../../constants");
var _routes = require("../../../../routes");
var _source_logic = require("../../source_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSynchronizationSubNav = () => {
  const {
    contentSource: {
      id,
      isSyncConfigEnabled
    }
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  if (!id || !isSyncConfigEnabled) return undefined;
  const navItems = [{
    id: 'sourceSynchronizationFrequency',
    name: _constants.NAV.SYNCHRONIZATION_FREQUENCY,
    ...(0, _layout.generateNavLink)({
      to: (0, _routes.getContentSourcePath)(_routes.SYNC_FREQUENCY_PATH, id, true),
      shouldShowActiveForSubroutes: true
    })
  }, {
    id: 'sourceSynchronizationAssetsAndObjects',
    name: _constants.NAV.SYNCHRONIZATION_ASSETS_AND_OBJECTS,
    ...(0, _layout.generateNavLink)({
      to: (0, _routes.getContentSourcePath)(_routes.ASSETS_AND_OBJECTS_PATH, id, true)
    })
  }];
  return navItems;
};
exports.useSynchronizationSubNav = useSynchronizationSubNav;