"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceLayout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
var _app_logic = require("../../../app_logic");
var _layout = require("../../../components/layout");
var _constants = require("../../../constants");
var _constants2 = require("../constants");
var _source_logic = require("../source_logic");
var _download_diagnostics_button = require("./download_diagnostics_button");
var _source_info_card = require("./source_info_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceLayout = ({
  children,
  pageChrome = [],
  ...props
}) => {
  const {
    contentSource,
    dataLoading,
    diagnosticDownloadButtonVisible
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    name,
    supportedByLicense
  } = contentSource;
  const pageHeader = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_source_info_card.SourceInfoCard, {
    contentSource: contentSource
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
  const callout = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _constants2.SOURCE_DISABLED_CALLOUT_TITLE,
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants2.SOURCE_DISABLED_CALLOUT_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    href: _doc_links.docLinks.licenseManagement
  }, _constants2.SOURCE_DISABLED_CALLOUT_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  const downloadDiagnosticButton = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_download_diagnostics_button.DownloadDiagnosticsButton, {
    label: _constants2.DOWNLOAD_DIAGNOSTIC_BUTTON
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }));
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  return /*#__PURE__*/_react.default.createElement(Layout, (0, _extends2.default)({
    isLoading: dataLoading
  }, props, {
    pageChrome: [_constants.NAV.SOURCES, name || '...', ...pageChrome]
  }), diagnosticDownloadButtonVisible && downloadDiagnosticButton, !supportedByLicense && callout, pageHeader, children);
};
exports.SourceLayout = SourceLayout;