"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../shared/doc_links");
var _truncate = require("../../../../shared/truncate");
var _component_loader = require("../../../components/shared/component_loader");
var _table_pagination_bar = require("../../../components/shared/table_pagination_bar");
var _view_content_header = require("../../../components/shared/view_content_header");
var _constants = require("../../../constants");
var _constants2 = require("../constants");
var _source_logic = require("../source_logic");
var _source_layout = require("./source_layout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_LENGTH = 28;
const SourceContent = () => {
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    setActivePage,
    searchContentSourceDocuments,
    setContentFilterValue
  } = (0, _kea.useActions)(_source_logic.SourceLogic);
  const {
    contentSource: {
      id,
      serviceType,
      urlField,
      titleField,
      urlFieldIsLinkable,
      isFederatedSource
    },
    contentMeta: {
      page: {
        total_pages: totalPages,
        total_results: totalItems,
        current: activePage
      }
    },
    contentItems,
    contentFilterValue,
    sectionLoading
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  (0, _react.useEffect)(() => {
    searchContentSourceDocuments(id);
  }, [contentFilterValue, activePage]);
  const showPagination = totalPages > 1;
  const hasItems = totalItems > 0;
  const emptyMessage = contentFilterValue ? _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.noContentForValue.message', {
    defaultMessage: "No results for '{contentFilterValue}'",
    values: {
      contentFilterValue
    }
  }) : _constants2.NO_CONTENT_MESSAGE;
  const paginationOptions = {
    totalPages,
    totalItems,
    activePage,
    onChangePage: page => {
      // EUI component starts page at 0. API starts at 1.
      setActivePage(page + 1);
    }
  };
  const isCustomSource = serviceType === _constants.CUSTOM_SERVICE_TYPE;
  const emptyState = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, emptyMessage),
    iconType: "documents",
    body: isCustomSource ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.workplaceSearch.sources.customSourceDocs.text",
      defaultMessage: "Learn more about adding content in our {documentationLink}",
      values: {
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: _doc_links.docLinks.workplaceSearchCustomSources
        }, _constants2.CUSTOM_DOCUMENTATION_LINK)
      }
    })) : null
  }));
  const contentItem = item => {
    const {
      id: itemId,
      last_updated: updated
    } = item;
    const url = item[urlField] || '';
    const title = item[titleField] || '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      key: itemId,
      "data-test-subj": "ContentItemRow"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      className: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
      tooltipType: "title",
      content: title.toString(),
      length: MAX_LENGTH
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      className: "eui-textTruncate",
      "data-test-subj": "URLFieldCell"
    }, !urlFieldIsLinkable && /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
      tooltipType: "title",
      content: url.toString(),
      length: MAX_LENGTH
    }), urlFieldIsLinkable && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: url.toString()
    }, /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
      tooltipType: "title",
      content: url.toString(),
      length: MAX_LENGTH
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      align: "right"
    }, (0, _moment.default)(updated).format('M/D/YYYY, h:mm:ss A')));
  };
  const contentTable = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showPagination && /*#__PURE__*/_react.default.createElement(_table_pagination_bar.TablePaginationBar, paginationOptions), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTable, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants2.TITLE_HEADING), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, (0, _lodash.startCase)(urlField)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "right"
  }, _constants2.LAST_UPDATED_HEADING)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, contentItems.map(contentItem))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showPagination && /*#__PURE__*/_react.default.createElement(_table_pagination_bar.TablePaginationBar, (0, _extends2.default)({}, paginationOptions, {
    hideLabelCount: true
  })));
  const resetFederatedSearchTerm = () => {
    setContentFilterValue('');
    setSearchTerm('');
  };
  const federatedSearchControls = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !searchTerm,
    fill: true,
    color: "primary",
    onClick: () => setContentFilterValue(searchTerm)
  }, _constants2.GO_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: !searchTerm,
    onClick: resetFederatedSearchTerm
  }, _constants2.RESET_BUTTON)));
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageChrome: [_constants.NAV.CONTENT],
    pageViewTelemetry: "source_overview"
  }, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants2.SOURCE_CONTENT_TITLE
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    disabled: !hasItems && !contentFilterValue,
    placeholder: isFederatedSource ? _constants2.SEARCH_CONTENT_PLACEHOLDER : _constants2.FILTER_CONTENT_PLACEHOLDER,
    incremental: !isFederatedSource,
    isClearable: !isFederatedSource,
    onSearch: setContentFilterValue,
    "data-test-subj": "ContentFilterInput",
    value: searchTerm,
    onChange: e => setSearchTerm(e.target.value)
  })), isFederatedSource && federatedSearchControls), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), sectionLoading && /*#__PURE__*/_react.default.createElement(_component_loader.ComponentLoader, {
    text: _constants2.CONTENT_LOADING_TEXT
  }), !sectionLoading && (hasItems ? contentTable : emptyState));
};
exports.SourceContent = SourceContent;