"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldEditorModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _display_settings_logic = require("./display_settings_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyField = {
  fieldName: '',
  label: ''
};
const FieldEditorModal = () => {
  const {
    toggleFieldEditorModal,
    addDetailField,
    updateDetailField
  } = (0, _kea.useActions)(_display_settings_logic.DisplaySettingsLogic);
  const {
    searchResultConfig: {
      detailFields
    },
    availableFieldOptions,
    fieldOptions,
    editFieldIndex
  } = (0, _kea.useValues)(_display_settings_logic.DisplaySettingsLogic);
  const isEditing = editFieldIndex || editFieldIndex === 0;
  const field = isEditing ? detailFields[editFieldIndex || 0] : emptyField;
  const [fieldName, setName] = (0, _react.useState)(field.fieldName || '');
  const [label, setLabel] = (0, _react.useState)(field.label || '');
  const handleSubmit = e => {
    e.preventDefault();
    if (isEditing) {
      updateDetailField({
        fieldName,
        label
      }, editFieldIndex);
    } else {
      addDetailField({
        fieldName,
        label
      });
    }
  };
  const ACTION_LABEL = isEditing ? _constants.UPDATE_LABEL : _constants.ADD_LABEL;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: toggleFieldEditorModal,
    maxWidth: 475
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, ACTION_LABEL, " ", _constants.FIELD_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.FIELD_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: isEditing ? fieldOptions : availableFieldOptions,
    name: "field",
    required: true,
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "AvailableFieldOptions",
    value: fieldName,
    disabled: !!isEditing,
    onChange: e => setName(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.LABEL_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "label",
    required: true,
    "data-test-subj": "VisibleFieldName",
    value: label,
    onChange: e => setLabel(e.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleFieldEditorModal
  }, _constants.CANCEL_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "FieldSubmitButton",
    color: "primary",
    fill: true,
    type: "submit"
  }, ACTION_LABEL, " ", _constants.FIELD_LABEL))));
};
exports.FieldEditorModal = FieldEditorModal;