"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisplaySettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
require("./display_settings.scss");
var _eui = require("@elastic/eui");
var _flash_messages = require("../../../../../shared/flash_messages");
var _unsaved_changes_prompt = require("../../../../../shared/unsaved_changes_prompt");
var _view_content_header = require("../../../../components/shared/view_content_header");
var _constants = require("../../../../constants");
var _source_layout = require("../source_layout");
var _constants2 = require("./constants");
var _display_settings_logic = require("./display_settings_logic");
var _field_editor_modal = require("./field_editor_modal");
var _result_detail = require("./result_detail");
var _search_results = require("./search_results");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DisplaySettings = ({
  tabId
}) => {
  const {
    initializeDisplaySettings,
    setServerData,
    handleSelectedTabChanged
  } = (0, _kea.useActions)(_display_settings_logic.DisplaySettingsLogic);
  const {
    dataLoading,
    addFieldModalVisible,
    unsavedChanges,
    exampleDocuments,
    navigatingBetweenTabs
  } = (0, _kea.useValues)(_display_settings_logic.DisplaySettingsLogic);
  const hasDocuments = exampleDocuments.length > 0;
  const hasUnsavedChanges = hasDocuments && unsavedChanges;
  (0, _react.useEffect)(() => {
    initializeDisplaySettings();
    return _flash_messages.clearFlashMessages;
  }, []);
  const tabs = [{
    id: 'search_results',
    name: _constants2.SEARCH_RESULTS_LABEL,
    content: /*#__PURE__*/_react.default.createElement(_search_results.SearchResults, null)
  }, {
    id: 'result_detail',
    name: _constants2.RESULT_DETAIL_LABEL,
    content: /*#__PURE__*/_react.default.createElement(_result_detail.ResultDetail, null)
  }];
  const onSelectedTabChanged = tab => {
    handleSelectedTabChanged(tab.id);
  };
  const handleFormSubmit = e => {
    e.preventDefault();
    setServerData();
  };
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageChrome: [_constants.NAV.DISPLAY_SETTINGS],
    pageViewTelemetry: "source_display_settings",
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: !navigatingBetweenTabs && hasUnsavedChanges,
    messageText: _constants2.UNSAVED_MESSAGE
  }), /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleFormSubmit
  }, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants2.DISPLAY_SETTINGS_TITLE,
    description: _constants2.DISPLAY_SETTINGS_DESCRIPTION,
    action: hasDocuments ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      type: "submit",
      disabled: !unsavedChanges,
      fill: true
    }, _constants.SAVE_BUTTON) : null
  }), hasDocuments ? /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    selectedTab: tabs[tabId],
    onTabClick: onSelectedTabChanged
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "indexRollupApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.DISPLAY_SETTINGS_EMPTY_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, _constants2.DISPLAY_SETTINGS_EMPTY_BODY)
  }))), addFieldModalVisible && /*#__PURE__*/_react.default.createElement(_field_editor_modal.FieldEditorModal, null));
};
exports.DisplaySettings = DisplaySettings;