"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigCompleted = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _routes = require("../../../../routes");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigCompleted = ({
  name,
  advanceStep,
  accountContextOnly,
  header,
  privateSourcesEnabled,
  showFeedbackLink
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, header, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xxl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  color: "subdued",
  paddingSize: "l"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  alignItems: "stretch",
  direction: "column",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  alignItems: "center",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "checkInCircleFilled",
  color: "success",
  size: "xxl"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
  textAlign: "center"
}, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configCompleted.heading', {
  defaultMessage: '{name} Configured',
  values: {
    name
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
  textAlign: "center"
}, !accountContextOnly ? /*#__PURE__*/_react.default.createElement("p", {
  "data-test-subj": "OrgCanConnectMessage"
}, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configCompleted.orgCanConnect.message', {
  defaultMessage: '{name} can now be connected to Workplace Search',
  values: {
    name
  }
})) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  grow: false,
  "data-test-subj": "PersonalConnectLinkMessage"
}, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configCompleted.personalConnectLink.message', {
  defaultMessage: 'Users can now link their {name} accounts from their personal dashboards.',
  values: {
    name
  }
})), !privateSourcesEnabled && /*#__PURE__*/_react.default.createElement("p", {
  "data-test-subj": "PrivateDisabledMessage"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCompleted.privateDisabled.message",
  defaultMessage: "Remember to {securityLink} in Security settings.",
  values: {
    securityLink: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: _routes.SECURITY_PATH
    }, _constants.CONFIG_COMPLETED_PRIVATE_SOURCES_DISABLED_LINK)
  }
})), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  target: "_blank",
  "data-test-subj": "ConfigCompletedPrivateSourcesDocsLink",
  href: _doc_links.docLinks.workplaceSearchPrivateSourcePermissions
}, _constants.CONFIG_COMPLETED_PRIVATE_SOURCES_DOCS_LINK))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  alignItems: "center",
  direction: "row",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
  to: (0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, true),
  fill: accountContextOnly,
  color: accountContextOnly ? 'primary' : undefined
}, _constants.CONFIG_COMPLETED_CONFIGURE_NEW_BUTTON)), !accountContextOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  color: "primary",
  fill: true,
  onClick: advanceStep,
  "data-test-subj": "ConfigCompletedConnectButton"
}, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configCompleted.connect.button', {
  defaultMessage: 'Connect {name}',
  values: {
    name
  }
}))))), showFeedbackLink && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  size: "s",
  color: "primary",
  iconType: "email",
  title: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/kibana/feedback",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.configCompleted.feedbackCallOutText', {
    defaultMessage: 'Have feedback about deploying a {name} Connector Package? Let us know.',
    values: {
      name
    }
  }))
})))));
exports.ConfigCompleted = ConfigCompleted;