"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSource = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _flash_messages = require("../../../../../shared/flash_messages");
var _kibana = require("../../../../../shared/kibana");
var _licensing = require("../../../../../shared/licensing");
var _app_logic = require("../../../../app_logic");
var _layout = require("../../../../components/layout");
var _constants = require("../../../../constants");
var _routes = require("../../../../routes");
var _source_data = require("../../source_data");
var _add_source_header = require("./add_source_header");
var _add_source_logic = require("./add_source_logic");
var _config_completed = require("./config_completed");
var _configure_oauth = require("./configure_oauth");
var _connect_instance = require("./connect_instance");
var _reauthenticate = require("./reauthenticate");
var _save_config = require("./save_config");
require("./add_source.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddSource = () => {
  const {
    serviceType,
    initialStep
  } = (0, _reactRouterDom.useParams)();
  const addSourceLogic = (0, _add_source_logic.AddSourceLogic)({
    serviceType,
    initialStep
  });
  const {
    getSourceConfigData,
    setAddSourceStep,
    saveSourceConfig,
    resetSourceState
  } = (0, _kea.useActions)(addSourceLogic);
  const {
    addSourceCurrentStep,
    sourceConfigData,
    dataLoading
  } = (0, _kea.useValues)(addSourceLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useEffect)(() => {
    getSourceConfigData();
    return resetSourceState;
  }, [serviceType]);
  const sourceData = (0, _source_data.getSourceData)(serviceType);
  if (!sourceData) {
    return null;
  }
  const {
    configuration,
    features,
    objTypes
  } = sourceData;
  const {
    name,
    categories,
    needsPermissions,
    accountContextOnly,
    privateSourcesEnabled
  } = sourceConfigData;
  if (!hasPlatinumLicense && accountContextOnly) {
    navigateToUrl((0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, isOrganization));
  }
  const goToConfigurationIntro = () => _kibana.KibanaLogic.values.navigateToUrl(`${(0, _routes.getSourcesPath)((0, _routes.getAddPath)(serviceType), isOrganization)}/intro`);
  const setConfigCompletedStep = () => setAddSourceStep(_add_source_logic.AddSourceSteps.ConfigCompletedStep);
  const goToConfigCompleted = () => saveSourceConfig(false, setConfigCompletedStep);
  const FORM_SOURCE_ADDED_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.formSourceAddedSuccessMessage', {
    defaultMessage: '{name} connected',
    values: {
      name
    }
  });
  const goToConnectInstance = () => setAddSourceStep(_add_source_logic.AddSourceSteps.ConnectInstanceStep);
  const goToFormSourceCreated = () => {
    _kibana.KibanaLogic.values.navigateToUrl(`${(0, _routes.getSourcesPath)(_routes.SOURCES_PATH, isOrganization)}`);
    (0, _flash_messages.flashSuccessToast)(FORM_SOURCE_ADDED_SUCCESS_MESSAGE);
  };
  const header = /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: serviceType,
    categories: categories
  });
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  return /*#__PURE__*/_react.default.createElement(Layout, {
    pageChrome: [_constants.NAV.SOURCES, _constants.NAV.ADD_SOURCE, name || '...'],
    isLoading: dataLoading
  }, addSourceCurrentStep === _add_source_logic.AddSourceSteps.SaveConfigStep && /*#__PURE__*/_react.default.createElement(_save_config.SaveConfig, {
    name: name,
    configuration: configuration,
    advanceStep: goToConfigCompleted,
    goBackStep: goToConfigurationIntro,
    header: header
  }), addSourceCurrentStep === _add_source_logic.AddSourceSteps.ConfigCompletedStep && /*#__PURE__*/_react.default.createElement(_config_completed.ConfigCompleted, {
    name: name,
    accountContextOnly: accountContextOnly,
    advanceStep: goToConnectInstance,
    privateSourcesEnabled: privateSourcesEnabled,
    header: header,
    showFeedbackLink: serviceType === 'external'
  }), addSourceCurrentStep === _add_source_logic.AddSourceSteps.ConnectInstanceStep && /*#__PURE__*/_react.default.createElement(_connect_instance.ConnectInstance, {
    name: name,
    serviceType: serviceType,
    configuration: configuration,
    features: features,
    objTypes: objTypes,
    needsPermissions: !!needsPermissions,
    onFormCreated: goToFormSourceCreated,
    header: header
  }), addSourceCurrentStep === _add_source_logic.AddSourceSteps.ConfigureOauthStep && /*#__PURE__*/_react.default.createElement(_configure_oauth.ConfigureOauth, {
    name: name,
    onFormCreated: goToFormSourceCreated,
    header: header
  }), addSourceCurrentStep === _add_source_logic.AddSourceSteps.ReauthenticateStep && /*#__PURE__*/_react.default.createElement(_reauthenticate.Reauthenticate, {
    name: name,
    header: header
  }));
};
exports.AddSource = AddSource;