"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalConnectorFormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _external_connector_logic = require("./external_connector_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalConnectorFormFields = () => {
  const {
    urlValid,
    externalConnectorApiKey,
    externalConnectorUrl,
    formDisabled,
    showInsecureUrlCallout
  } = (0, _kea.useValues)(_external_connector_logic.ExternalConnectorLogic);
  const {
    fetchExternalSource,
    validateUrl,
    setExternalConnectorApiKey,
    setExternalConnectorUrl
  } = (0, _kea.useActions)(_external_connector_logic.ExternalConnectorLogic);
  (0, _react.useEffect)(() => {
    fetchExternalSource();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showInsecureUrlCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.insecureTitle', {
      defaultMessage: 'Connection not secure'
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.insecureWarning', {
    defaultMessage: 'Your connector is using an HTTP connection, which is not private. Information synced by this connector could be viewed by others. Connect over HTTPS to secure your information.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.urlLabel', {
      defaultMessage: 'Connector URL'
    }),
    isInvalid: !urlValid,
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.helpText', {
      defaultMessage: 'URLs should start with https://'
    }),
    error: urlValid ? [] : [_i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.error', {
      defaultMessage: 'Please use a valid URL'
    })]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: externalConnectorUrl,
    disabled: formDisabled,
    onBlur: validateUrl,
    required: true,
    type: "text",
    autoComplete: "off",
    onChange: e => setExternalConnectorUrl(e.target.value),
    name: "external-connector-url"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.apiKeyLabel', {
      defaultMessage: 'Connector API key'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: externalConnectorApiKey,
    disabled: formDisabled,
    required: true,
    type: "text",
    autoComplete: "off",
    onChange: e => setExternalConnectorApiKey(e.target.value),
    name: "external-connector-api-key"
  })));
};
exports.ExternalConnectorFormFields = ExternalConnectorFormFields;