"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_LABEL = exports.UPDATE_LABEL = exports.UPDATE_BUTTON = exports.STATUS_POPOVER_TOOLTIP = exports.STANDARD_SOURCES_TOGGLE_TEXT = exports.STANDARD_SOURCES_TABLE_DESCRIPTION = exports.STANDARD_SOURCES_EMPTY_TABLE_TITLE = exports.SOURCE_STATUSES = exports.SOURCE_RESTRICTIONS_SUCCESS_MESSAGE = exports.SOURCE_OBJ_TYPES = exports.SOURCE_NAMES = exports.SOURCE_CATEGORIES = exports.SOURCE = exports.SECURITY_UNSAVED_CHANGES_MESSAGE = exports.SEARCHABLE_HEADER = exports.SAVE_SETTINGS_BUTTON = exports.SAVE_CHANGES_BUTTON = exports.SAVE_BUTTON = exports.RESET_BUTTON = exports.REMOVE_FIELD_LABEL = exports.REMOVE_BUTTON = exports.REMOTE_SOURCES_TOGGLE_TEXT = exports.REMOTE_SOURCES_TABLE_DESCRIPTION = exports.REMOTE_SOURCES_EMPTY_TABLE_TITLE = exports.REDIRECT_URIS_LABEL = exports.REDIRECT_SECURE_ERROR_TEXT = exports.REDIRECT_NATIVE_HELP_TEXT = exports.REDIRECT_INSECURE_ERROR_TEXT = exports.REDIRECT_HELP_TEXT = exports.RECENT_ACTIVITY_TITLE = exports.PUBLIC_KEY_LABEL = exports.PRIVATE_VIEW_ONLY_PAGE_TITLE = exports.PRIVATE_VIEW_ONLY_PAGE_DESCRIPTION = exports.PRIVATE_SOURCES_UPDATE_CONFIRMATION_TEXT = exports.PRIVATE_SOURCES_TOGGLE_DESCRIPTION = exports.PRIVATE_SOURCES_DESCRIPTION = exports.PRIVATE_SOURCES = exports.PRIVATE_SOURCE = exports.PRIVATE_PLATINUM_LICENSE_CALLOUT = exports.PRIVATE_CAN_CREATE_PAGE_TITLE = exports.PRIVATE_CAN_CREATE_PAGE_DESCRIPTION = exports.PLATINUM_FEATURE = exports.ORG_UPDATED_MESSAGE = exports.ON_LABEL = exports.OK_BUTTON = exports.OAUTH_PERSISTED_DESCRIPTION = exports.OAUTH_DESCRIPTION = exports.OAUTH_APP_UPDATED_MESSAGE = exports.NON_PLATINUM_OAUTH_TITLE = exports.NON_PLATINUM_OAUTH_DESCRIPTION = exports.NAV = exports.NAME_LABEL = exports.MAX_TABLE_ROW_ICONS = exports.LABEL_LABEL = exports.KEEP_EDITING_BUTTON = exports.GITHUB_VIA_APP_SERVICE_TYPE = exports.GITHUB_LINK_TITLE = exports.GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE = exports.FIELD_LABEL = exports.EXTERNAL_SERVICE_TYPE = exports.EXTERNAL_CONNECTOR_URL_LABEL = exports.EXTERNAL_CONNECTOR_API_KEY_LABEL = exports.EXPLORE_PLATINUM_FEATURES_LINK = exports.EDIT_FIELD_LABEL = exports.DOCUMENTS_HEADER = exports.DOCUMENTATION_LINK_TITLE = exports.DESCRIPTION_LABEL = exports.CUSTOM_SERVICE_TYPE = exports.CUSTOMIZE_NAME_LABEL = exports.CUSTOMIZE_NAME_BUTTON = exports.CUSTOMIZE_HEADER_TITLE = exports.CUSTOMIZE_HEADER_DESCRIPTION = exports.CREDENTIALS_TITLE = exports.CREDENTIALS_DESCRIPTION = exports.COPY_TOOLTIP = exports.COPY_TEXT = exports.COPIED_TOOLTIP = exports.CONSUMER_KEY_LABEL = exports.CONNECTORS_HEADER_TITLE = exports.CONNECTORS_HEADER_DESCRIPTION = exports.CONFIRM_MODAL_TITLE = exports.CONFIRM_CHANGES_TEXT = exports.CONFIGURE_BUTTON = exports.CONFIDENTIAL_LABEL = exports.CONFIDENTIAL_HELP_TEXT = exports.CLIENT_SECRET_LABEL = exports.CLIENT_ID_LABEL = exports.CANCEL_BUTTON = exports.BLOCK_LABEL = exports.BETWEEN_LABEL = exports.BASE_URL_LABEL = exports.BASE_URI_LABEL = exports.API_KEY_LABEL = exports.API_KEYS_TITLE = exports.AND = exports.ADD_LABEL = exports.ADD_FIELD_LABEL = exports.ACCOUNT_SETTINGS_TITLE = exports.ACCOUNT_SETTINGS_DESCRIPTION = exports.ACCOUNT_NAV = void 0;
exports.WORKPLACE_SEARCH_TITLE = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WORKPLACE_SEARCH_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.title', {
  defaultMessage: 'Workplace Search'
});
exports.WORKPLACE_SEARCH_TITLE = WORKPLACE_SEARCH_TITLE;
const NAV = {
  OVERVIEW: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.overview', {
    defaultMessage: 'Overview'
  }),
  SOURCES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.sources', {
    defaultMessage: 'Sources'
  }),
  GROUPS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.groups', {
    defaultMessage: 'Groups'
  }),
  GROUP_OVERVIEW: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.groups.groupOverview', {
    defaultMessage: 'Overview'
  }),
  SOURCE_PRIORITIZATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.groups.sourcePrioritization', {
    defaultMessage: 'Source Prioritization'
  }),
  CONTENT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.content', {
    defaultMessage: 'Content'
  }),
  ROLE_MAPPINGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.roleMappings', {
    defaultMessage: 'Users and roles'
  }),
  API_KEYS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.apiKeys', {
    defaultMessage: 'API keys'
  }),
  SECURITY: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.security', {
    defaultMessage: 'Security'
  }),
  SCHEMA: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.schema', {
    defaultMessage: 'Schema'
  }),
  SYNCHRONIZATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.synchronization', {
    defaultMessage: 'Synchronization'
  }),
  SYNCHRONIZATION_FREQUENCY: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.synchronizationFrequency', {
    defaultMessage: 'Frequency'
  }),
  SYNCHRONIZATION_ASSETS_AND_OBJECTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.synchronizationAssetsAndObjects', {
    defaultMessage: 'Assets and objects'
  }),
  DISPLAY_SETTINGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.displaySettings', {
    defaultMessage: 'Display Settings'
  }),
  SETTINGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.settings', {
    defaultMessage: 'Settings'
  }),
  SETTINGS_CUSTOMIZE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.settingsCustomize', {
    defaultMessage: 'Customize'
  }),
  SETTINGS_SOURCE_PRIORITIZATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.settingsSourcePrioritization', {
    defaultMessage: 'Content source connectors'
  }),
  SETTINGS_OAUTH: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.settingsOauth', {
    defaultMessage: 'OAuth application'
  }),
  ADD_SOURCE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.addSource', {
    defaultMessage: 'Add Source'
  }),
  PERSONAL_DASHBOARD: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.personalDashboard', {
    defaultMessage: 'View my personal dashboard'
  }),
  SEARCH: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nav.searchApplication', {
    defaultMessage: 'Go to search application'
  })
};
exports.NAV = NAV;
const ACCOUNT_NAV = {
  SOURCES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.sources.link', {
    defaultMessage: 'Content sources'
  }),
  ORG_DASHBOARD: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.orgDashboard.link', {
    defaultMessage: 'Go to organizational dashboard'
  }),
  SEARCH: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.search.link', {
    defaultMessage: 'Search'
  }),
  ACCOUNT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.account.link', {
    defaultMessage: 'My account'
  }),
  SETTINGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.settings.link', {
    defaultMessage: 'Account settings'
  }),
  LOGOUT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountNav.logout.link', {
    defaultMessage: 'Logout'
  })
};
exports.ACCOUNT_NAV = ACCOUNT_NAV;
const MAX_TABLE_ROW_ICONS = 3;
exports.MAX_TABLE_ROW_ICONS = MAX_TABLE_ROW_ICONS;
const SOURCE_STATUSES = {
  INDEXING: 'indexing',
  SYNCED: 'synced',
  SYNCING: 'syncing',
  AWAITING_USER_ACTION: 'awaiting_user_action',
  ERROR: 'error',
  DISCONNECTED: 'disconnected',
  ALWAYS_SYNCED: 'always_synced'
};
exports.SOURCE_STATUSES = SOURCE_STATUSES;
const SOURCE_NAMES = {
  BOX: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.box', {
    defaultMessage: 'Box'
  }),
  CONFLUENCE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.confluence', {
    defaultMessage: 'Confluence'
  }),
  CONFLUENCE_CONNECTOR_PACKAGE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.confluenceConnectorPackage', {
    defaultMessage: 'Confluence Connector Package'
  }),
  CONFLUENCE_SERVER: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.confluenceServer', {
    defaultMessage: 'Confluence (Server)'
  }),
  DROPBOX: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.dropbox', {
    defaultMessage: 'Dropbox'
  }),
  GITHUB: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.github', {
    defaultMessage: 'GitHub'
  }),
  GITHUB_ENTERPRISE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.githubEnterprise', {
    defaultMessage: 'GitHub Enterprise Server'
  }),
  GMAIL: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.gmail', {
    defaultMessage: 'Gmail'
  }),
  GOOGLE_DRIVE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.googleDrive', {
    defaultMessage: 'Google Drive'
  }),
  JIRA: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.jira', {
    defaultMessage: 'Jira'
  }),
  JIRA_SERVER: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.jiraServer', {
    defaultMessage: 'Jira (Server)'
  }),
  NETWORK_DRVE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.networkDrive', {
    defaultMessage: 'Network Drive'
  }),
  ONEDRIVE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.oneDrive', {
    defaultMessage: 'OneDrive'
  }),
  OUTLOOK: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.outlook', {
    defaultMessage: 'Outlook'
  }),
  SALESFORCE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.salesforce', {
    defaultMessage: 'Salesforce'
  }),
  SALESFORCE_SANDBOX: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.salesforceSandbox', {
    defaultMessage: 'Salesforce Sandbox'
  }),
  SERVICENOW: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.serviceNow', {
    defaultMessage: 'ServiceNow'
  }),
  SHAREPOINT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.sharePoint', {
    defaultMessage: 'SharePoint Online'
  }),
  SHAREPOINT_CONNECTOR_PACKAGE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.sharePointConnectorPackage', {
    defaultMessage: 'SharePoint Online Connector Package'
  }),
  SHAREPOINT_SERVER: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.sharePointServer', {
    defaultMessage: 'SharePoint Server'
  }),
  SLACK: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.slack', {
    defaultMessage: 'Slack'
  }),
  TEAMS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.teams', {
    defaultMessage: 'Teams'
  }),
  ZENDESK: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.zendesk', {
    defaultMessage: 'Zendesk'
  }),
  ZOOM: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.zoom', {
    defaultMessage: 'Zoom'
  }),
  CUSTOM: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.custom', {
    defaultMessage: 'Custom API Source'
  }),
  CUSTOM_CONNECTOR_PACKAGE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceNames.customConnectorPackage', {
    defaultMessage: 'Custom Connector Package'
  })
};
exports.SOURCE_NAMES = SOURCE_NAMES;
const SOURCE_OBJ_TYPES = {
  FOLDERS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.folders', {
    defaultMessage: 'Folders'
  }),
  PAGES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.pages', {
    defaultMessage: 'Pages'
  }),
  ATTACHMENTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.attachments', {
    defaultMessage: 'Attachments'
  }),
  BLOG_POSTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.blogPosts', {
    defaultMessage: 'Blog Posts'
  }),
  SITES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.sites', {
    defaultMessage: 'Sites'
  }),
  SPACES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.spaces', {
    defaultMessage: 'Spaces'
  }),
  ALL_FILES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.allFiles', {
    defaultMessage: 'All Files (including images, PDFs, spreadsheets, textual documents, presentations)'
  }),
  ALL_STORED_FILES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.allStoredFiles', {
    defaultMessage: 'All Stored Files (including images, videos, PDFs, spreadsheets, textual documents, presentations)'
  }),
  G_SUITE_FILES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.gSuiteFiles', {
    defaultMessage: 'Google G Suite Documents (Docs, Sheets, Slides)'
  }),
  EPICS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.epics', {
    defaultMessage: 'Epics'
  }),
  PROJECTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.projects', {
    defaultMessage: 'Projects'
  }),
  TASKS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.tasks', {
    defaultMessage: 'Tasks'
  }),
  STORIES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.stories', {
    defaultMessage: 'Stories'
  }),
  BUGS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.bugs', {
    defaultMessage: 'Bugs'
  }),
  ISSUES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.issues', {
    defaultMessage: 'Issues (including comments)'
  }),
  PULL_REQUESTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.pullRequests', {
    defaultMessage: 'Pull Requests (including comments)'
  }),
  REPOSITORY_LIST: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.repositoryList', {
    defaultMessage: 'Repository List'
  }),
  FILES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.files', {
    defaultMessage: 'Files (markdown only)'
  }),
  EMAILS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.emails', {
    defaultMessage: 'Emails'
  }),
  CONTACTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.contacts', {
    defaultMessage: 'Contacts'
  }),
  OPPORTUNITIES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.opportunities', {
    defaultMessage: 'Opportunities'
  }),
  LEADS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.leads', {
    defaultMessage: 'Leads'
  }),
  ACCOUNTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.accounts', {
    defaultMessage: 'Accounts'
  }),
  CAMPAIGNS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.campaigns', {
    defaultMessage: 'Campaigns'
  }),
  CASES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.cases', {
    defaultMessage: 'Cases (including feeds and comments)'
  }),
  USERS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.users', {
    defaultMessage: 'Users'
  }),
  INCIDENTS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.incidents', {
    defaultMessage: 'Incidents'
  }),
  ITEMS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.items', {
    defaultMessage: 'Items'
  }),
  ARTICLES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.articles', {
    defaultMessage: 'Articles'
  }),
  TICKETS: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.tickets', {
    defaultMessage: 'Tickets'
  }),
  PUBLIC_MESSAGES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.publicMessages', {
    defaultMessage: 'Public channel messages'
  }),
  PRIVATE_MESSAGES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.privateMessages', {
    defaultMessage: 'Private channel messages in which you are an active participant'
  }),
  DIRECT_MESSAGES: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.objTypes.directMessages', {
    defaultMessage: 'Direct messages'
  })
};
exports.SOURCE_OBJ_TYPES = SOURCE_OBJ_TYPES;
const SOURCE_CATEGORIES = {
  ACCOUNT_MANAGEMENT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.accountManagement', {
    defaultMessage: 'Account management'
  }),
  ATLASSIAN: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.atlassian', {
    defaultMessage: 'Atlassian'
  }),
  BUG_TRACKING: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.bugTracking', {
    defaultMessage: 'Bug tracking'
  }),
  CHAT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.chat', {
    defaultMessage: 'Chat'
  }),
  CLOUD: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.cloud', {
    defaultMessage: 'Cloud'
  }),
  CODE_REPOSITORY: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.codeRepository', {
    defaultMessage: 'Code repository'
  }),
  COLLABORATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.collaboration', {
    defaultMessage: 'Collaboration'
  }),
  COMMUNICATION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.communication', {
    defaultMessage: 'Communication'
  }),
  CRM: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.crm', {
    defaultMessage: 'CRM'
  }),
  CUSTOMER_RELATIONSHIP_MANAGEMENT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.customerRelationshipManagement', {
    defaultMessage: 'Customer relationship management'
  }),
  CUSTOMER_SERVICE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.customerService', {
    defaultMessage: 'Customer service'
  }),
  EMAIL: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.email', {
    defaultMessage: 'Email'
  }),
  FILE_SHARING: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.fileSharing', {
    defaultMessage: 'File sharing'
  }),
  GOOGLE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.google', {
    defaultMessage: 'Google'
  }),
  GSUITE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.gsuite', {
    defaultMessage: 'GSuite'
  }),
  HELP: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.help', {
    defaultMessage: 'Help'
  }),
  HELPDESK: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.helpdesk', {
    defaultMessage: 'Helpdesk'
  }),
  INSTANT_MESSAGING: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.instantMessaging', {
    defaultMessage: 'Instant messaging'
  }),
  INTRANET: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.intranet', {
    defaultMessage: 'Intranet'
  }),
  MICROSOFT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.microsoft', {
    defaultMessage: 'Microsoft'
  }),
  OFFICE_365: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.office', {
    defaultMessage: 'Office 365'
  }),
  PRODUCTIVITY: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.productivity', {
    defaultMessage: 'Productivity'
  }),
  PROJECT_MANAGEMENT: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.projectManagement', {
    defaultMessage: 'Project management'
  }),
  SOFTWARE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.software', {
    defaultMessage: 'Software'
  }),
  STORAGE: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.storage', {
    defaultMessage: 'Storage'
  }),
  TICKETING: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.ticketing', {
    defaultMessage: 'Ticketing'
  }),
  VERSION_CONTROL: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.versionControl', {
    defaultMessage: 'Version control'
  }),
  WIKI: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.wiki', {
    defaultMessage: 'Wiki'
  }),
  WORKFLOW: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.categories.workflow', {
    defaultMessage: 'Workflow'
  })
};
exports.SOURCE_CATEGORIES = SOURCE_CATEGORIES;
const API_KEYS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.apiKeysTitle', {
  defaultMessage: 'API keys'
});
exports.API_KEYS_TITLE = API_KEYS_TITLE;
const API_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.apiKeyLabel', {
  defaultMessage: 'API key'
});
exports.API_KEY_LABEL = API_KEY_LABEL;
const GITHUB_LINK_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.applicationLinkTitles.github', {
  defaultMessage: 'GitHub Developer Portal'
});
exports.GITHUB_LINK_TITLE = GITHUB_LINK_TITLE;
const GITHUB_VIA_APP_SERVICE_TYPE = 'github_via_app';
exports.GITHUB_VIA_APP_SERVICE_TYPE = GITHUB_VIA_APP_SERVICE_TYPE;
const GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE = 'github_enterprise_server_via_app';
exports.GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE = GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE;
const CUSTOM_SERVICE_TYPE = 'custom';
exports.CUSTOM_SERVICE_TYPE = CUSTOM_SERVICE_TYPE;
const EXTERNAL_SERVICE_TYPE = 'external';
exports.EXTERNAL_SERVICE_TYPE = EXTERNAL_SERVICE_TYPE;
const DOCUMENTATION_LINK_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.documentation', {
  defaultMessage: 'Documentation'
});
exports.DOCUMENTATION_LINK_TITLE = DOCUMENTATION_LINK_TITLE;
const PRIVATE_SOURCES_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.privateSources.description', {
  defaultMessage: 'Private sources are connected by users in your organization to create a personalized search experience.'
});
exports.PRIVATE_SOURCES_DESCRIPTION = PRIVATE_SOURCES_DESCRIPTION;
const PRIVATE_SOURCES_TOGGLE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.privateSourcesToggle.description', {
  defaultMessage: 'Enable private sources for your organization'
});
exports.PRIVATE_SOURCES_TOGGLE_DESCRIPTION = PRIVATE_SOURCES_TOGGLE_DESCRIPTION;
const REMOTE_SOURCES_TOGGLE_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.remoteSourcesToggle.text', {
  defaultMessage: 'Enable remote private sources'
});
exports.REMOTE_SOURCES_TOGGLE_TEXT = REMOTE_SOURCES_TOGGLE_TEXT;
const REMOTE_SOURCES_TABLE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.remoteSourcesTable.description', {
  defaultMessage: 'Remote sources synchronize and store a limited amount of data on disk, with a low impact on storage resources.'
});
exports.REMOTE_SOURCES_TABLE_DESCRIPTION = REMOTE_SOURCES_TABLE_DESCRIPTION;
const REMOTE_SOURCES_EMPTY_TABLE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.remoteSourcesEmptyTable.title', {
  defaultMessage: 'No remote private sources configured yet'
});
exports.REMOTE_SOURCES_EMPTY_TABLE_TITLE = REMOTE_SOURCES_EMPTY_TABLE_TITLE;
const STANDARD_SOURCES_TOGGLE_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.standardSourcesToggle.text', {
  defaultMessage: 'Enable standard private sources'
});
exports.STANDARD_SOURCES_TOGGLE_TEXT = STANDARD_SOURCES_TOGGLE_TEXT;
const STANDARD_SOURCES_TABLE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.standardSourcesTable.description', {
  defaultMessage: 'Standard sources synchronize and store all searchable data on disk, with a directly correlated impact on storage resources.'
});
exports.STANDARD_SOURCES_TABLE_DESCRIPTION = STANDARD_SOURCES_TABLE_DESCRIPTION;
const STANDARD_SOURCES_EMPTY_TABLE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.standardSourcesEmptyTable.title', {
  defaultMessage: 'No standard private sources configured yet'
});
exports.STANDARD_SOURCES_EMPTY_TABLE_TITLE = STANDARD_SOURCES_EMPTY_TABLE_TITLE;
const SECURITY_UNSAVED_CHANGES_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.unsavedChanges.message', {
  defaultMessage: 'Your private sources settings have not been saved. Are you sure you want to leave?'
});
exports.SECURITY_UNSAVED_CHANGES_MESSAGE = SECURITY_UNSAVED_CHANGES_MESSAGE;
const PRIVATE_SOURCES_UPDATE_CONFIRMATION_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.privateSourcesUpdateConfirmation.text', {
  defaultMessage: 'Updates to private source configuration will take effect immediately.'
});
exports.PRIVATE_SOURCES_UPDATE_CONFIRMATION_TEXT = PRIVATE_SOURCES_UPDATE_CONFIRMATION_TEXT;
const SOURCE_RESTRICTIONS_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.sourceRestrictionsSuccess.message', {
  defaultMessage: 'Successfully updated source restrictions.'
});
exports.SOURCE_RESTRICTIONS_SUCCESS_MESSAGE = SOURCE_RESTRICTIONS_SUCCESS_MESSAGE;
const PUBLIC_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.publicKey.label', {
  defaultMessage: 'Public Key'
});
exports.PUBLIC_KEY_LABEL = PUBLIC_KEY_LABEL;
const CONSUMER_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.consumerKey.label', {
  defaultMessage: 'Consumer Key'
});
exports.CONSUMER_KEY_LABEL = CONSUMER_KEY_LABEL;
const BASE_URI_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.baseUri.label', {
  defaultMessage: 'Base URI'
});
exports.BASE_URI_LABEL = BASE_URI_LABEL;
const BASE_URL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.baseUrl.label', {
  defaultMessage: 'Base URL'
});
exports.BASE_URL_LABEL = BASE_URL_LABEL;
const EXTERNAL_CONNECTOR_URL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.externalConnectorUrl.label', {
  defaultMessage: 'Connector URL'
});
exports.EXTERNAL_CONNECTOR_URL_LABEL = EXTERNAL_CONNECTOR_URL_LABEL;
const EXTERNAL_CONNECTOR_API_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.externalConnectorApiKey.label', {
  defaultMessage: 'Connector API key'
});
exports.EXTERNAL_CONNECTOR_API_KEY_LABEL = EXTERNAL_CONNECTOR_API_KEY_LABEL;
const CLIENT_ID_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.clientId.label', {
  defaultMessage: 'Client id'
});
exports.CLIENT_ID_LABEL = CLIENT_ID_LABEL;
const CLIENT_SECRET_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.clientSecret.label', {
  defaultMessage: 'Client secret'
});
exports.CLIENT_SECRET_LABEL = CLIENT_SECRET_LABEL;
const CONFIDENTIAL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.confidential.label', {
  defaultMessage: 'Confidential'
});
exports.CONFIDENTIAL_LABEL = CONFIDENTIAL_LABEL;
const CONFIDENTIAL_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.confidential.text', {
  defaultMessage: 'Deselect for environments in which the client secret cannot be kept confidential, such as native mobile apps and single page applications.'
});
exports.CONFIDENTIAL_HELP_TEXT = CONFIDENTIAL_HELP_TEXT;
const CREDENTIALS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentials.title', {
  defaultMessage: 'Credentials'
});
exports.CREDENTIALS_TITLE = CREDENTIALS_TITLE;
const CREDENTIALS_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentials.description', {
  defaultMessage: 'Use the following credentials within your client to request access tokens from our authentication server.'
});
exports.CREDENTIALS_DESCRIPTION = CREDENTIALS_DESCRIPTION;
const ORG_UPDATED_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.orgUpdated.message', {
  defaultMessage: 'Successfully updated organization.'
});
exports.ORG_UPDATED_MESSAGE = ORG_UPDATED_MESSAGE;
const OAUTH_APP_UPDATED_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.oauthAppUpdated.message', {
  defaultMessage: 'Successfully updated application.'
});
exports.OAUTH_APP_UPDATED_MESSAGE = OAUTH_APP_UPDATED_MESSAGE;
const SAVE_CHANGES_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.saveChanges.button', {
  defaultMessage: 'Save changes'
});
exports.SAVE_CHANGES_BUTTON = SAVE_CHANGES_BUTTON;
const SAVE_SETTINGS_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.saveSettings.button', {
  defaultMessage: 'Save settings'
});
exports.SAVE_SETTINGS_BUTTON = SAVE_SETTINGS_BUTTON;
const KEEP_EDITING_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.keepEditing.button', {
  defaultMessage: 'Keep editing'
});
exports.KEEP_EDITING_BUTTON = KEEP_EDITING_BUTTON;
const NAME_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.name.label', {
  defaultMessage: 'Name'
});
exports.NAME_LABEL = NAME_LABEL;
const OAUTH_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauth.description', {
  defaultMessage: 'Create an OAuth client for your organization.'
});
exports.OAUTH_DESCRIPTION = OAUTH_DESCRIPTION;
const OAUTH_PERSISTED_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthPersisted.description', {
  defaultMessage: "Access your organization's OAuth client credentials and manage OAuth settings."
});
exports.OAUTH_PERSISTED_DESCRIPTION = OAUTH_PERSISTED_DESCRIPTION;
const REDIRECT_URIS_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectURIs.label', {
  defaultMessage: 'Redirect URIs'
});
exports.REDIRECT_URIS_LABEL = REDIRECT_URIS_LABEL;
const REDIRECT_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectHelp.text', {
  defaultMessage: 'Provide one URI per line.'
});
exports.REDIRECT_HELP_TEXT = REDIRECT_HELP_TEXT;
const REDIRECT_NATIVE_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectNativeHelp.text', {
  defaultMessage: 'For local development URIs, use format'
});
exports.REDIRECT_NATIVE_HELP_TEXT = REDIRECT_NATIVE_HELP_TEXT;
const REDIRECT_SECURE_ERROR_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectSecureError.text', {
  defaultMessage: 'Cannot contain duplicate redirect URIs.'
});
exports.REDIRECT_SECURE_ERROR_TEXT = REDIRECT_SECURE_ERROR_TEXT;
const REDIRECT_INSECURE_ERROR_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.redirectInsecureError.text', {
  defaultMessage: 'Using an insecure redirect URI (http) is not recommended.'
});
exports.REDIRECT_INSECURE_ERROR_TEXT = REDIRECT_INSECURE_ERROR_TEXT;
const NON_PLATINUM_OAUTH_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nonPlatinumOauthTitle', {
  defaultMessage: 'Configuring OAuth for Custom Search Applications'
});
exports.NON_PLATINUM_OAUTH_TITLE = NON_PLATINUM_OAUTH_TITLE;
const NON_PLATINUM_OAUTH_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.nonPlatinumOauthDescription', {
  defaultMessage: 'Configure an OAuth application for secure use of the Workplace Search Search API. Upgrade to a Platinum license to enable the Search API and create your OAuth application.'
});
exports.NON_PLATINUM_OAUTH_DESCRIPTION = NON_PLATINUM_OAUTH_DESCRIPTION;
const EXPLORE_PLATINUM_FEATURES_LINK = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.explorePlatinumFeatures.link', {
  defaultMessage: 'Explore Platinum features'
});
exports.EXPLORE_PLATINUM_FEATURES_LINK = EXPLORE_PLATINUM_FEATURES_LINK;
const CUSTOMIZE_HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.customize.header.title', {
  defaultMessage: 'Customize Workplace Search'
});
exports.CUSTOMIZE_HEADER_TITLE = CUSTOMIZE_HEADER_TITLE;
const CUSTOMIZE_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.customize.header.description', {
  defaultMessage: 'Personalize general organization settings.'
});
exports.CUSTOMIZE_HEADER_DESCRIPTION = CUSTOMIZE_HEADER_DESCRIPTION;
const CUSTOMIZE_NAME_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.customize.name.label', {
  defaultMessage: 'Organization name'
});
exports.CUSTOMIZE_NAME_LABEL = CUSTOMIZE_NAME_LABEL;
const CUSTOMIZE_NAME_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.customize.name.button', {
  defaultMessage: 'Save organization name'
});
exports.CUSTOMIZE_NAME_BUTTON = CUSTOMIZE_NAME_BUTTON;
const UPDATE_BUTTON = _constants.UPDATE_BUTTON_LABEL;
exports.UPDATE_BUTTON = UPDATE_BUTTON;
const SAVE_BUTTON = _constants.SAVE_BUTTON_LABEL;
exports.SAVE_BUTTON = SAVE_BUTTON;
const CANCEL_BUTTON = _constants.CANCEL_BUTTON_LABEL;
exports.CANCEL_BUTTON = CANCEL_BUTTON;
const RESET_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.reset.button', {
  defaultMessage: 'Reset'
});
exports.RESET_BUTTON = RESET_BUTTON;
const CONFIGURE_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.configure.button', {
  defaultMessage: 'Configure'
});
exports.CONFIGURE_BUTTON = CONFIGURE_BUTTON;
const OK_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.ok.button', {
  defaultMessage: 'Ok'
});
exports.OK_BUTTON = OK_BUTTON;
const PRIVATE_PLATINUM_LICENSE_CALLOUT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.privatePlatinumCallout.text', {
  defaultMessage: 'Private Sources require a Platinum license.'
});
exports.PRIVATE_PLATINUM_LICENSE_CALLOUT = PRIVATE_PLATINUM_LICENSE_CALLOUT;
const SOURCE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.source.text', {
  defaultMessage: 'Source'
});
exports.SOURCE = SOURCE;
const PRIVATE_SOURCE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.privateSource.text', {
  defaultMessage: 'Private Source'
});
exports.PRIVATE_SOURCE = PRIVATE_SOURCE;
const PRIVATE_SOURCES = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.privateSources.text', {
  defaultMessage: 'Private Sources'
});
exports.PRIVATE_SOURCES = PRIVATE_SOURCES;
const PRIVATE_CAN_CREATE_PAGE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.private.canCreate.title', {
  defaultMessage: 'Manage private content sources'
});
exports.PRIVATE_CAN_CREATE_PAGE_TITLE = PRIVATE_CAN_CREATE_PAGE_TITLE;
const PRIVATE_VIEW_ONLY_PAGE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.private.vewOnly.title', {
  defaultMessage: 'Review Group Sources'
});
exports.PRIVATE_VIEW_ONLY_PAGE_TITLE = PRIVATE_VIEW_ONLY_PAGE_TITLE;
const PRIVATE_VIEW_ONLY_PAGE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.private.vewOnly.description', {
  defaultMessage: 'Review the status of all sources shared with your Group.'
});
exports.PRIVATE_VIEW_ONLY_PAGE_DESCRIPTION = PRIVATE_VIEW_ONLY_PAGE_DESCRIPTION;
const PRIVATE_CAN_CREATE_PAGE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.private.canCreate.description', {
  defaultMessage: 'Review the status of all connected private sources, and manage private sources for your account.'
});
exports.PRIVATE_CAN_CREATE_PAGE_DESCRIPTION = PRIVATE_CAN_CREATE_PAGE_DESCRIPTION;
const ACCOUNT_SETTINGS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountSettings.title', {
  defaultMessage: 'Account Settings'
});
exports.ACCOUNT_SETTINGS_TITLE = ACCOUNT_SETTINGS_TITLE;
const ACCOUNT_SETTINGS_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.accountSettings.description', {
  defaultMessage: 'Manage access, passwords, and other account settings.'
});
exports.ACCOUNT_SETTINGS_DESCRIPTION = ACCOUNT_SETTINGS_DESCRIPTION;
const CONFIRM_CHANGES_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.confirmChanges.text', {
  defaultMessage: 'Confirm changes'
});
exports.CONFIRM_CHANGES_TEXT = CONFIRM_CHANGES_TEXT;
const CONNECTORS_HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.connectors.header.title', {
  defaultMessage: 'Content source connectors'
});
exports.CONNECTORS_HEADER_TITLE = CONNECTORS_HEADER_TITLE;
const CONNECTORS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.connectors.header.description', {
  defaultMessage: 'All of your configurable connectors.'
});
exports.CONNECTORS_HEADER_DESCRIPTION = CONNECTORS_HEADER_DESCRIPTION;
const URL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.url.label', {
  defaultMessage: 'URL'
});
exports.URL_LABEL = URL_LABEL;
const FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.field.label', {
  defaultMessage: 'Field'
});
exports.FIELD_LABEL = FIELD_LABEL;
const LABEL_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.label.label', {
  defaultMessage: 'Label'
});
exports.LABEL_LABEL = LABEL_LABEL;
const DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.description.label', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_LABEL = DESCRIPTION_LABEL;
const BLOCK_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.blockLabel', {
  defaultMessage: 'Block'
});
exports.BLOCK_LABEL = BLOCK_LABEL;
const BETWEEN_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.betweenLabel', {
  defaultMessage: 'between'
});
exports.BETWEEN_LABEL = BETWEEN_LABEL;
const ON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.onLabel', {
  defaultMessage: 'on'
});
exports.ON_LABEL = ON_LABEL;
const AND = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.and', {
  defaultMessage: 'and'
});
exports.AND = AND;
const UPDATE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.update.label', {
  defaultMessage: 'Update'
});
exports.UPDATE_LABEL = UPDATE_LABEL;
const ADD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.add.label', {
  defaultMessage: 'Add'
});
exports.ADD_LABEL = ADD_LABEL;
const ADD_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.addField.label', {
  defaultMessage: 'Add field'
});
exports.ADD_FIELD_LABEL = ADD_FIELD_LABEL;
const EDIT_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.editField.label', {
  defaultMessage: 'Edit field'
});
exports.EDIT_FIELD_LABEL = EDIT_FIELD_LABEL;
const REMOVE_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.removeField.label', {
  defaultMessage: 'Remove field'
});
exports.REMOVE_FIELD_LABEL = REMOVE_FIELD_LABEL;
const RECENT_ACTIVITY_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.recentActivity.title', {
  defaultMessage: 'Recent activity'
});
exports.RECENT_ACTIVITY_TITLE = RECENT_ACTIVITY_TITLE;
const CONFIRM_MODAL_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.comfirmModal.title', {
  defaultMessage: 'Please confirm'
});
exports.CONFIRM_MODAL_TITLE = CONFIRM_MODAL_TITLE;
const REMOVE_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.remove.button', {
  defaultMessage: 'Remove'
});
exports.REMOVE_BUTTON = REMOVE_BUTTON;
const COPY_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.copyText', {
  defaultMessage: 'Copy'
});
exports.COPY_TEXT = COPY_TEXT;
const STATUS_POPOVER_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.statusPopoverTooltip', {
  defaultMessage: 'Click to view info'
});
exports.STATUS_POPOVER_TOOLTIP = STATUS_POPOVER_TOOLTIP;
const DOCUMENTS_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.documentsHeader', {
  defaultMessage: 'Documents'
});
exports.DOCUMENTS_HEADER = DOCUMENTS_HEADER;
const SEARCHABLE_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.searchableHeader', {
  defaultMessage: 'Searchable'
});
exports.SEARCHABLE_HEADER = SEARCHABLE_HEADER;
const PLATINUM_FEATURE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.platinumFeature', {
  defaultMessage: 'Platinum feature'
});
exports.PLATINUM_FEATURE = PLATINUM_FEATURE;
const COPY_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.copy.tooltip', {
  defaultMessage: 'Copy to clipboard'
});
exports.COPY_TOOLTIP = COPY_TOOLTIP;
const COPIED_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.copied.tooltip', {
  defaultMessage: 'Copied!'
});
exports.COPIED_TOOLTIP = COPIED_TOOLTIP;