"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncatedContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _ = require(".");
require("./truncated_content.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TruncatedContent = ({
  content,
  length,
  beginning = false,
  tooltipType = 'inline'
}) => {
  if (content.length <= length) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content);
  const inline = tooltipType === 'inline';
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "truncated-content",
    title: !inline ? content : ''
  }, beginning ? (0, _.truncateBeginning)(content, length) : (0, _.truncate)(content, length), inline && /*#__PURE__*/_react.default.createElement("span", {
    className: "truncated-content__tooltip"
  }, content));
};
exports.TruncatedContent = TruncatedContent;