"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupGuideLayout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _kibana = require("../kibana");
var _instructions = require("./cloud/instructions");
var _constants = require("./constants");
var _instructions2 = require("./instructions");
require("./setup_guide.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetupGuideLayout = ({
  children,
  productName,
  productEuiIcon
}) => {
  const {
    cloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const isCloudEnabled = Boolean(cloud.isCloudEnabled);
  const cloudDeploymentLink = cloud.deploymentUrl || '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    className: "setupGuide",
    "data-test-subj": "setupGuide"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSideBar_Deprecated, {
    className: "setupGuide__sidebar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _constants.SETUP_GUIDE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: productEuiIcon,
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h1", null, productName)))), children), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    className: "setupGuide__body"
  }, isCloudEnabled ? /*#__PURE__*/_react.default.createElement(_instructions.CloudSetupInstructions, {
    productName: productName,
    cloudDeploymentLink: cloudDeploymentLink
  }) : /*#__PURE__*/_react.default.createElement(_instructions2.SetupInstructions, {
    productName: productName
  })));
};
exports.SetupGuideLayout = SetupGuideLayout;