"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaFieldTypeSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaFieldTypeSelect = ({
  fieldName,
  fieldType,
  updateExistingFieldType,
  disabled,
  ...rest
}) => {
  const fieldTypeOptions = Object.values(_types.SchemaType).filter(type => !_types.IgnoreSchemaTypes.includes(type)).map(type => ({
    value: type,
    text: type
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, rest, {
    name: fieldName,
    required: true,
    value: fieldType,
    options: fieldTypeOptions,
    disabled: disabled,
    onChange: e => updateExistingFieldType(fieldName, e.target.value),
    "data-test-subj": "SchemaSelect"
  }));
};
exports.SchemaFieldTypeSelect = SchemaFieldTypeSelect;