"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaAddFieldModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _2 = require("..");
var _constants = require("../../constants");
var _constants2 = require("../constants");
var _types = require("../types");
var _constants3 = require("./constants");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaAddFieldModal = ({
  addNewField,
  addFieldFormErrors,
  closeAddFieldModal,
  disableForm
}) => {
  const [loading, setLoading] = (0, _react.useState)(false);
  const [newFieldType, updateNewFieldType] = (0, _react.useState)(_types.SchemaType.Text);
  const [formattedFieldName, setFormattedFieldName] = (0, _react.useState)('');
  const [rawFieldName, setRawFieldName] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (addFieldFormErrors) setLoading(false);
  }, [addFieldFormErrors]);
  const handleChange = ({
    currentTarget: {
      value
    }
  }) => {
    setRawFieldName(value);
    setFormattedFieldName((0, _utils.formatFieldName)(value));
  };
  const submitForm = e => {
    e.preventDefault();
    addNewField(formattedFieldName, newFieldType);
    setLoading(true);
  };
  const fieldNameNote = rawFieldName !== formattedFieldName ? (0, _constants3.FIELD_NAME_CORRECTED_NOTE)(formattedFieldName) : _constants3.FIELD_NAME_CORRECT_NOTE;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeAddFieldModal,
    maxWidth: 500
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _constants3.ADD_FIELD_MODAL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    iconType: "iInCircle",
    title: /*#__PURE__*/_react.default.createElement("p", null, _constants3.ADD_FIELD_MODAL_DESCRIPTION)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    id: _constants3.FORM_ID,
    onSubmit: submitForm
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.FIELD_NAME,
    helpText: fieldNameNote,
    fullWidth: true,
    "data-test-subj": "SchemaAddFieldNameRow",
    error: /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textBreakAll"
    }, addFieldFormErrors),
    isInvalid: !!addFieldFormErrors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _constants3.FIELD_NAME_PLACEHOLDER,
    onChange: handleChange,
    value: rawFieldName,
    fullWidth: true,
    autoFocus: true,
    required: true,
    isLoading: loading,
    disabled: disableForm,
    "data-test-subj": "SchemaAddFieldNameField"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.FIELD_TYPE,
    "data-test-subj": "SchemaAddFieldTypeRow"
  }, /*#__PURE__*/_react.default.createElement(_2.SchemaFieldTypeSelect, {
    fieldName: "",
    fieldType: newFieldType,
    updateExistingFieldType: (_, type) => updateNewFieldType(type),
    disabled: disableForm,
    "data-test-subj": "SchemaSelect"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeAddFieldModal
  }, _constants.CANCEL_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    form: _constants3.FORM_ID,
    isLoading: loading,
    disabled: disableForm,
    "data-test-subj": "SchemaAddFieldButton"
  }, _constants3.ADD_FIELD_BUTTON)));
};
exports.SchemaAddFieldModal = SchemaAddFieldModal;