"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultField = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
require("./result.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const iconMap = {
  boolean: 'tokenBoolean',
  date: 'tokenDate',
  date_range: 'tokenDate',
  double: 'tokenNumber',
  double_range: 'tokenDate',
  flattened: 'tokenObject',
  float: 'tokenNumber',
  float_range: 'tokenNumber',
  geo_point: 'tokenGeo',
  geo_shape: 'tokenGeo',
  half_float: 'tokenNumber',
  histogram: 'tokenHistogram',
  integer: 'tokenNumber',
  integer_range: 'tokenNumber',
  ip: 'tokenIp',
  ip_range: 'tokenIp',
  join: 'tokenJoin',
  keyword: 'tokenKeyword',
  long: 'tokenNumber',
  long_range: 'tokenNumber',
  nested: 'tokenObject',
  object: 'tokenObject',
  percolator: 'tokenPercolator',
  rank_feature: 'tokenRankFeature',
  rank_features: 'tokenRankFeatures',
  scaled_float: 'tokenNumber',
  search_as_you_type: 'tokenSearchType',
  shape: 'tokenShape',
  short: 'tokenNumber',
  text: 'tokenString',
  token_count: 'tokenTokenCount',
  unsigned_long: 'tokenNumber'
};
const defaultToken = 'questionInCircle';
const ResultField = ({
  iconType,
  fieldName,
  fieldValue,
  fieldType,
  isExpanded
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    className: "resultField"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    className: "resultFieldRowCell",
    width: _uiTheme.euiThemeVars.euiSizeL,
    valign: "middle"
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    className: "resultField__token",
    iconType: iconType || (fieldType ? iconMap[fieldType] : defaultToken)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    className: "resultFieldRowCell",
    width: "25%",
    truncateText: !isExpanded,
    valign: "middle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    className: "resultFieldRowCell",
    width: _uiTheme.euiThemeVars.euiSizeXXL,
    valign: "middle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    color: "subdued"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    className: "resultFieldRowCell",
    truncateText: !isExpanded,
    valign: "middle"
  }, (fieldType === 'object' || fieldType === 'array' || fieldType === 'nested' || Array.isArray(fieldValue)) && isExpanded ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    overflowHeight: "250",
    transparentBackground: true
  }, fieldValue) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, fieldValue)));
};
exports.ResultField = ResultField;