"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Result = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _result_fields = require("./result_fields");
var _result_header = require("./result_header");
require("./result.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Result = ({
  metaData,
  fields
}) => {
  var _metaData$title;
  const [isExpanded, setIsExpanded] = (0, _react.useState)(false);
  const tooltipText = fields.length <= 3 ? _i18n.i18n.translate('xpack.enterpriseSearch.shared.result.expandTooltip.allVisible', {
    defaultMessage: 'All fields are visible'
  }) : isExpanded ? _i18n.i18n.translate('xpack.enterpriseSearch.shared.result.expandTooltip.showFewer', {
    defaultMessage: 'Show {amount} fewer fields',
    values: {
      amount: fields.length - 3
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.shared.result.expandTooltip.showMore', {
    defaultMessage: 'Show {amount} more fields',
    values: {
      amount: fields.length - 3
    }
  });
  const toolTipContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tooltipText);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_result_header.ResultHeader, {
    title: (_metaData$title = metaData.title) !== null && _metaData$title !== void 0 ? _metaData$title : _i18n.i18n.translate('xpack.enterpriseSearch.shared.result.title.id', {
      defaultMessage: 'Document id: {id}',
      values: {
        id: metaData.id
      }
    }),
    metaData: metaData
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_result_fields.ResultFields, {
    isExpanded: isExpanded,
    fields: isExpanded ? fields : fields.slice(0, 3)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "resultExpandColumn"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: toolTipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isExpanded ? 'fold' : 'unfold',
    color: "text",
    onClick: () => setIsExpanded(!isExpanded),
    "aria-label": tooltipText
  }))))));
};
exports.Result = Result;