"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchPageTemplateWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _flash_messages = require("../flash_messages");
var _http = require("../http");
var _loading = require("../loading");
require("./page_template.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchPageTemplateWrapper = ({
  children,
  className,
  customPageSections,
  hideFlashMessages,
  isLoading,
  isEmptyState,
  emptyState,
  setPageChrome,
  solutionNav,
  ...pageTemplateProps
}) => {
  var _pageTemplateProps$ma;
  const {
    readOnlyMode
  } = (0, _kea.useValues)(_http.HttpLogic);
  const hasCustomEmptyState = !!emptyState;
  const showCustomEmptyState = hasCustomEmptyState && isEmptyState;
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, (0, _extends2.default)({
    restrictWidth: false
  }, pageTemplateProps, {
    className: (0, _classnames.default)('enterpriseSearchPageTemplate', className),
    mainProps: {
      ...pageTemplateProps.mainProps,
      className: (0, _classnames.default)('enterpriseSearchPageTemplate__content', (_pageTemplateProps$ma = pageTemplateProps.mainProps) === null || _pageTemplateProps$ma === void 0 ? void 0 : _pageTemplateProps$ma.className)
    },
    isEmptyState: isEmptyState && !isLoading,
    solutionNav: solutionNav ? {
      icon: 'logoEnterpriseSearch',
      ...solutionNav
    } : undefined
  }), setPageChrome, readOnlyMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "lock",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.readOnlyMode.warning', {
      defaultMessage: 'Enterprise Search is in read-only mode. You will be unable to make changes such as creating, editing, or deleting.'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), !hideFlashMessages && /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null), isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : showCustomEmptyState ? emptyState : customPageSections ? children : /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, children));
};
exports.EnterpriseSearchPageTemplateWrapper = EnterpriseSearchPageTemplateWrapper;