"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnterpriseSearchNav = exports.useEnterpriseSearchEngineNav = exports.useEnterpriseSearchAnalyticsNav = void 0;
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _routes = require("../../applications/routes");
var _routes2 = require("../../enterprise_search_content/routes");
var _kibana = require("../kibana");
var _nav_link_helpers = require("./nav_link_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEnterpriseSearchNav = () => {
  const {
    productAccess,
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const navItems = [{
    id: 'es_overview',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.enterpriseSearchOverviewTitle', {
      defaultMessage: 'Overview'
    }),
    ...(0, _nav_link_helpers.generateNavLink)({
      shouldNotCreateHref: true,
      to: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.URL
    }),
    items: [{
      id: 'elasticsearch',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.elasticsearchTitle', {
        defaultMessage: 'Elasticsearch'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ELASTICSEARCH_PLUGIN.URL
      })
    }, {
      id: 'searchExperiences',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchExperiencesTitle', {
        defaultMessage: 'Search Experiences'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.SEARCH_EXPERIENCES_PLUGIN.URL
      })
    }]
  }, {
    id: 'content',
    items: [{
      id: 'search_indices',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle', {
        defaultMessage: 'Indices'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes2.SEARCH_INDICES_PATH
      })
    }, ...(productFeatures.hasDefaultIngestPipeline ? [{
      id: 'settings',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.contentSettingsTitle', {
        defaultMessage: 'Settings'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes2.SETTINGS_PATH
      })
    }] : [])],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.contentTitle', {
      defaultMessage: 'Content'
    })
  }, {
    id: 'applications',
    items: [{
      id: 'searchApplications',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchApplicationsTitle', {
        defaultMessage: 'Search Applications'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.APPLICATIONS_PLUGIN.URL
      })
    }, {
      id: 'analyticsCollections',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsTitle', {
        defaultMessage: 'Behavioral Analytics'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ANALYTICS_PLUGIN.URL
      })
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.applicationsTitle', {
      defaultMessage: 'Applications'
    })
  }, ...(productAccess.hasAppSearchAccess || productAccess.hasWorkplaceSearchAccess ? [{
    id: 'standaloneExperiences',
    items: [...(productAccess.hasAppSearchAccess ? [{
      id: 'app_search',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.appSearchTitle', {
        defaultMessage: 'App Search'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.APP_SEARCH_PLUGIN.URL
      })
    }] : []), ...(productAccess.hasWorkplaceSearchAccess ? [{
      id: 'workplace_search',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.workplaceSearchTitle', {
        defaultMessage: 'Workplace Search'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.WORKPLACE_SEARCH_PLUGIN.URL
      })
    }] : [])],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.standaloneExperiencesTitle', {
      defaultMessage: 'Standalone Experiences'
    })
  }] : [])];
  return navItems;
};
exports.useEnterpriseSearchNav = useEnterpriseSearchNav;
const useEnterpriseSearchEngineNav = (engineName, isEmptyState) => {
  var _applicationsItem$ite;
  const navItems = useEnterpriseSearchNav();
  if (!engineName) return navItems;
  const applicationsItem = navItems.find(item => item.id === 'applications');
  if (!applicationsItem || !applicationsItem.items) return navItems;
  const enginesItem = (_applicationsItem$ite = applicationsItem.items) === null || _applicationsItem$ite === void 0 ? void 0 : _applicationsItem$ite.find(item => item.id === 'searchApplications');
  if (!enginesItem || enginesItem.id !== 'searchApplications') return navItems;
  const enginePath = `${_constants.APPLICATIONS_PLUGIN.URL}${_routes.ENGINES_PATH}/${engineName}`;
  enginesItem.items = !isEmptyState ? [{
    id: 'engineId',
    name: engineName,
    ...(0, _nav_link_helpers.generateNavLink)({
      shouldNotCreateHref: true,
      shouldShowActiveForSubroutes: true,
      to: enginePath
    }),
    items: [{
      id: 'enterpriseSearchEnginePreview',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.engine.previewTitle', {
        defaultMessage: 'Search Preview'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: `${enginePath}/${_routes.EngineViewTabs.PREVIEW}`
      })
    }, {
      id: 'enterpriseSearchApplicationsContent',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.engine.contentTitle', {
        defaultMessage: 'Content'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: `${enginePath}/${_routes.EngineViewTabs.CONTENT}`
      })
    }, {
      id: 'enterpriseSearchApplicationConnect',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.applications.searchApplications.connectTitle', {
        defaultMessage: 'Connect'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: `${enginePath}/${_routes.EngineViewTabs.CONNECT}`
      })
    }]
  }] : [{
    id: 'engineId',
    name: engineName,
    ...(0, _nav_link_helpers.generateNavLink)({
      shouldNotCreateHref: true,
      shouldShowActiveForSubroutes: true,
      to: enginePath
    })
  }];
  return navItems;
};
exports.useEnterpriseSearchEngineNav = useEnterpriseSearchEngineNav;
const useEnterpriseSearchAnalyticsNav = (name, paths) => {
  var _applicationsNav$item;
  const navItems = useEnterpriseSearchNav();
  const applicationsNav = navItems.find(item => item.id === 'applications');
  const analyticsNav = applicationsNav === null || applicationsNav === void 0 ? void 0 : (_applicationsNav$item = applicationsNav.items) === null || _applicationsNav$item === void 0 ? void 0 : _applicationsNav$item.find(item => item.id === 'analyticsCollections');
  if (!name || !paths || !analyticsNav) return navItems;
  analyticsNav.items = [{
    id: 'analyticsCollection',
    items: [{
      id: 'analyticsCollectionOverview',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.overviewTitle', {
        defaultMessage: 'Overview'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ANALYTICS_PLUGIN.URL + paths.overview
      })
    }, {
      id: 'analyticsCollectionExplorer',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.explorerTitle', {
        defaultMessage: 'Explorer'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ANALYTICS_PLUGIN.URL + paths.explorer
      })
    }, {
      id: 'analyticsCollectionIntegration',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.integrationTitle', {
        defaultMessage: 'Integration'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ANALYTICS_PLUGIN.URL + paths.integration
      })
    }],
    name
  }];
  return navItems;
};
exports.useEnterpriseSearchAnalyticsNav = useEnterpriseSearchAnalyticsNav;