"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workplaceSearchTitle = exports.searchExperiencesTitle = exports.generateTitle = exports.enterpriseSearchTitle = exports.elasticsearchTitle = exports.appSearchTitle = exports.analyticsTitle = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Given an array of page titles, return a final formatted document title
 * @param pages - e.g., ['Curations', 'some Engine', 'App Search']
 * @returns - e.g., 'Curations - some Engine - App Search'
 */
const generateTitle = pages => pages.join(' - ');

/**
 * Product-specific helpers
 */
exports.generateTitle = generateTitle;
const enterpriseSearchTitle = (page = []) => generateTitle([...page, _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.NAME]);
exports.enterpriseSearchTitle = enterpriseSearchTitle;
const analyticsTitle = (page = []) => generateTitle([...page, _constants.ANALYTICS_PLUGIN.NAME]);
exports.analyticsTitle = analyticsTitle;
const elasticsearchTitle = (page = []) => generateTitle([...page, 'Getting started with Elasticsearch']);
exports.elasticsearchTitle = elasticsearchTitle;
const appSearchTitle = (page = []) => generateTitle([...page, _constants.APP_SEARCH_PLUGIN.NAME]);
exports.appSearchTitle = appSearchTitle;
const workplaceSearchTitle = (page = []) => generateTitle([...page, _constants.WORKPLACE_SEARCH_PLUGIN.NAME]);
exports.workplaceSearchTitle = workplaceSearchTitle;
const searchExperiencesTitle = (page = []) => generateTitle([...page, _constants.SEARCH_EXPERIENCES_PLUGIN.NAME]);
exports.searchExperiencesTitle = searchExperiencesTitle;