"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GettingStartedSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _react_router_helpers = require("../react_router_helpers");
var _icon_row = require("./icon_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GettingStartedSteps = ({
  step = 'first'
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStartedSteps.addData.title', {
        defaultMessage: 'Add your documents to Enterprise Search'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStartedSteps.addData.message', {
        defaultMessage: 'Add your data to Enterprise Search. You can crawl website content with the Elastic web crawler, connect your existing application with Elasticsearch API endpoints, or use connectors to directly add third party content from providers like Google Drive, Microsoft Sharepoint and more.'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_icon_row.IconRow, null)),
      status: step === 'first' && 'current' || 'complete'
    }, {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStartedSteps.buildSearchExperience.title', {
        defaultMessage: 'Build a search experience'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStartedSteps.buildSearchExperience.message', {
        defaultMessage: 'Create a search engine with App Search for a prebuild set of search management tools, or deeply customize your own tools by searching directly against Elasticsearch. Then build beautiful client-side search experiences with Search UI - available for Elasticsearch, App Search, and Workplace Search.'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        shouldNotCreateHref: true,
        to: _constants.ELASTICSEARCH_PLUGIN.URL
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "iInCircle"
      }), "\xA0", _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStartedSteps.searchWithElasticsearchLink', {
        defaultMessage: 'Search with the Elasticsearch API'
      }))))),
      status: step === 'second' && 'current' || 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStartedSteps.tuneSearchExperience.title', {
        defaultMessage: 'Tune your search relevance'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStartedSteps.tuneSearchExperience.message', {
        defaultMessage: "Refine your search results by adjusting your search settings, including weighting certain fields or creating curations and synonyms. Then implement, measure, and dive into analytics to continue helping your users find exactly what they're looking for."
      }))),
      status: 'incomplete'
    }]
  })));
};
exports.GettingStartedSteps = GettingStartedSteps;