"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCloudEnterpriseSearchHost = getCloudEnterpriseSearchHost;
var _decode_cloud_id = require("../decode_cloud_id/decode_cloud_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getCloudEnterpriseSearchHost(cloud) {
  if (cloud && cloud.isCloudEnabled && cloud.cloudId) {
    const deploymentId = getDeploymentId(cloud.cloudId);
    const res = (0, _decode_cloud_id.decodeCloudId)(cloud.cloudId);
    if (!(deploymentId && res)) {
      return;
    }

    // Enterprise Search Server url are formed like this `https://<deploymentId>.ent.<host>
    return `https://${deploymentId}.ent.${res.host}${res.defaultPort !== '443' ? `:${res.defaultPort}` : ''}`;
  }
}
function getDeploymentId(cloudId) {
  const [deploymentId, rest] = cloudId.split(':');
  if (deploymentId && rest) {
    return deploymentId;
  }
}