"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toastAPIErrors = exports.getErrorsFromHttpResponse = exports.flashAPIErrors = exports.defaultErrorMessage = void 0;
var _i18n = require("@kbn/i18n");
var _flash_messages_logic = require("./flash_messages_logic");
var _set_message_helpers = require("./set_message_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultErrorMessage = _i18n.i18n.translate('xpack.enterpriseSearch.shared.flashMessages.defaultErrorMessage', {
  defaultMessage: 'An unexpected error occurred'
});
exports.defaultErrorMessage = defaultErrorMessage;
const getErrorsFromHttpResponse = response => {
  var _response$body, _response$body$attrib, _response$body2;
  return Array.isArray(response === null || response === void 0 ? void 0 : (_response$body = response.body) === null || _response$body === void 0 ? void 0 : (_response$body$attrib = _response$body.attributes) === null || _response$body$attrib === void 0 ? void 0 : _response$body$attrib.errors) ? response.body.attributes.errors : [(response === null || response === void 0 ? void 0 : (_response$body2 = response.body) === null || _response$body2 === void 0 ? void 0 : _response$body2.message) || defaultErrorMessage];
};

/**
 * Converts API/HTTP errors into user-facing Flash Messages
 */
exports.getErrorsFromHttpResponse = getErrorsFromHttpResponse;
const flashAPIErrors = (response, {
  isQueued
} = {}) => {
  var _response$body3;
  const errorFlashMessages = getErrorsFromHttpResponse(response).map(message => ({
    message,
    type: 'error'
  }));
  if (isQueued) {
    _flash_messages_logic.FlashMessagesLogic.actions.setQueuedMessages(errorFlashMessages);
  } else {
    _flash_messages_logic.FlashMessagesLogic.actions.setFlashMessages(errorFlashMessages);
  }

  // If this was a programming error or a failed request (such as a CORS) error,
  // we rethrow the error so it shows up in the developer console
  if (!(response !== null && response !== void 0 && (_response$body3 = response.body) !== null && _response$body3 !== void 0 && _response$body3.message)) {
    throw response;
  }
};
exports.flashAPIErrors = flashAPIErrors;
const toastAPIErrors = response => {
  var _response$body4;
  const messages = getErrorsFromHttpResponse(response);
  for (const message of messages) {
    (0, _set_message_helpers.flashErrorToast)(message);
  }
  // If this was a programming error or a failed request (such as a CORS) error,
  // we rethrow the error so it shows up in the developer console
  if (!(response !== null && response !== void 0 && (_response$body4 = response.body) !== null && _response$body4 !== void 0 && _response$body4.message)) {
    throw response;
  }
};
exports.toastAPIErrors = toastAPIErrors;