"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchResources = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchResources = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchResources.title', {
  defaultMessage: 'Resources'
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: _doc_links.docLinks.elasticsearchGettingStarted,
  target: "_blank"
}, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchResources.gettingStarted', {
  defaultMessage: 'Getting started with Elasticsearch'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: _doc_links.docLinks.elasticsearchCreateIndex,
  target: "_blank"
}, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchResources.createIndex', {
  defaultMessage: 'Create a new index'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: _doc_links.docLinks.clientsGuide,
  target: "_blank"
}, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchResources.elasticsearchClients', {
  defaultMessage: 'Setup a language client'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: "https://github.com/elastic/search-ui/tree/master/packages/search-ui-elasticsearch-connector",
  target: "_blank"
}, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchResources.searchUi', {
  defaultMessage: 'Search UI for Elasticsearch'
})));
exports.ElasticsearchResources = ElasticsearchResources;