"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronDaily = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CronDaily = ({
  disabled,
  minute,
  minuteOptions,
  hour,
  hourOptions,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.cronEditor.cronDaily.fieldTimeLabel",
    defaultMessage: "Time"
  }),
  fullWidth: true,
  "data-test-subj": "cronFrequencyConfiguration"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  disabled: disabled,
  options: hourOptions,
  value: hour,
  "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.cronEditor.cronDaily.hourSelectLabel', {
    defaultMessage: 'Hour'
  }),
  onChange: e => onChange({
    hour: e.target.value
  }),
  fullWidth: true,
  prepend: _i18n.i18n.translate('xpack.enterpriseSearch.cronEditor.cronDaily.fieldHour.textAtLabel', {
    defaultMessage: 'At'
  }),
  "data-test-subj": "cronFrequencyDailyHourSelect"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  disabled: disabled,
  options: minuteOptions,
  value: minute,
  "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.cronEditor.cronDaily.minuteSelectLabel', {
    defaultMessage: 'Minute'
  }),
  onChange: e => onChange({
    minute: e.target.value
  }),
  fullWidth: true,
  prepend: ":",
  "data-test-subj": "cronFrequencyDailyMinuteSelect"
})))));
exports.CronDaily = CronDaily;