"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.frequencyToFieldsMap = exports.frequencyToBaselineFieldsMap = exports.UNITS = exports.MONTH_OPTIONS = exports.MINUTE_OPTIONS = exports.HOUR_OPTIONS = exports.DAY_OPTIONS = exports.DATE_OPTIONS = void 0;
var _lodash = require("lodash");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function makeSequence(min, max) {
  const values = [];
  for (let i = min; i <= max; i++) {
    values.push(i);
  }
  return values;
}
const MINUTE_OPTIONS = makeSequence(0, 59).map(value => ({
  value: value.toString(),
  text: (0, _lodash.padStart)(value.toString(), 2, '0')
}));
exports.MINUTE_OPTIONS = MINUTE_OPTIONS;
const HOUR_OPTIONS = makeSequence(0, 23).map(value => ({
  value: value.toString(),
  text: (0, _lodash.padStart)(value.toString(), 2, '0')
}));
exports.HOUR_OPTIONS = HOUR_OPTIONS;
const DAY_OPTIONS = makeSequence(1, 7).map(value => ({
  value: value.toString(),
  text: (0, _services.getDayName)(value - 1)
}));
exports.DAY_OPTIONS = DAY_OPTIONS;
const DATE_OPTIONS = makeSequence(1, 31).map(value => ({
  value: value.toString(),
  text: (0, _services.getOrdinalValue)(value)
}));
exports.DATE_OPTIONS = DATE_OPTIONS;
const MONTH_OPTIONS = makeSequence(1, 12).map(value => ({
  value: value.toString(),
  text: (0, _services.getMonthName)(value - 1)
}));
exports.MONTH_OPTIONS = MONTH_OPTIONS;
const UNITS = [{
  value: 'MINUTE',
  text: 'minute'
}, {
  value: 'HOUR',
  text: 'hour'
}, {
  value: 'DAY',
  text: 'day'
}, {
  value: 'WEEK',
  text: 'week'
}, {
  value: 'MONTH',
  text: 'month'
}, {
  value: 'YEAR',
  text: 'year'
}];
exports.UNITS = UNITS;
const frequencyToFieldsMap = {
  MINUTE: {},
  HOUR: {
    minute: true
  },
  DAY: {
    hour: true,
    minute: true
  },
  WEEK: {
    day: true,
    hour: true,
    minute: true
  },
  MONTH: {
    date: true,
    hour: true,
    minute: true
  },
  YEAR: {
    month: true,
    date: true,
    hour: true,
    minute: true
  }
};
exports.frequencyToFieldsMap = frequencyToFieldsMap;
const frequencyToBaselineFieldsMap = {
  MINUTE: {
    second: '0',
    minute: '*',
    hour: '*',
    date: '*',
    month: '*',
    day: '?'
  },
  HOUR: {
    second: '0',
    minute: '0',
    hour: '*',
    date: '*',
    month: '*',
    day: '?'
  },
  DAY: {
    second: '0',
    minute: '0',
    hour: '0',
    date: '*',
    month: '*',
    day: '?'
  },
  WEEK: {
    second: '0',
    minute: '0',
    hour: '0',
    date: '?',
    month: '*',
    day: '7'
  },
  MONTH: {
    second: '0',
    minute: '0',
    hour: '0',
    date: '1',
    month: '*',
    day: '?'
  },
  YEAR: {
    second: '0',
    minute: '0',
    hour: '0',
    date: '1',
    month: '1',
    day: '?'
  }
};
exports.frequencyToBaselineFieldsMap = frequencyToBaselineFieldsMap;