"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("./accordion_list.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccordionList = ({
  hasBorder,
  iconType,
  initialIsOpen,
  items,
  rowCount = 10,
  title
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordionList'
  });
  const showPagination = items.length > rowCount;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: initialIsOpen,
    arrowProps: {
      isDisabled: items.length === 0
    },
    className: hasBorder ? 'appSearchAccordion--bordered' : 'appSearchAccordion',
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: iconType
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, title)))),
    id: accordionId,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: items.length > 0 ? 'accent' : 'subdued',
      size: "m"
    }, items.length)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items.map(item => ({
      item
    })),
    columns: [{
      render: ({
        item
      }) => item
    }],
    pagination: showPagination ? {
      showPerPageOptions: false
    } : false
  }), !showPagination && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.AccordionList = AccordionList;