"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderHeaderActions = exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../common/constants");
var _enterprise_search_url = require("./shared/enterprise_search_url");
var _flash_messages = require("./shared/flash_messages");
var _get_cloud_enterprise_search_host = require("./shared/get_cloud_enterprise_search_host/get_cloud_enterprise_search_host");
var _http = require("./shared/http");
var _kibana = require("./shared/kibana");
var _licensing = require("./shared/licensing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This file serves as a reusable wrapper to share Kibana-level context and other helpers
 * between various Enterprise Search plugins (e.g. AppSearch, WorkplaceSearch, ES landing page)
 * which should be imported and passed in as the first param in plugin.ts.
 */

const renderApp = (App, {
  params,
  core,
  plugins
}, {
  config,
  data
}) => {
  var _data$features, _plugins$cloud, _core$application$cap, _core$application$cap2;
  const {
    publicUrl,
    errorConnectingMessage,
    ...initialData
  } = data;
  const entCloudHost = (0, _get_cloud_enterprise_search_host.getCloudEnterpriseSearchHost)(plugins.cloud);
  _enterprise_search_url.externalUrl.enterpriseSearchUrl = publicUrl || entCloudHost || config.host || '';
  const noProductAccess = {
    hasAppSearchAccess: false,
    hasWorkplaceSearchAccess: false
  };
  const productAccess = data.access || noProductAccess;
  const productFeatures = (_data$features = data.features) !== null && _data$features !== void 0 ? _data$features : {
    ..._constants.DEFAULT_PRODUCT_FEATURES
  };
  const EmptyContext = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  const CloudContext = ((_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.CloudContextProvider) || EmptyContext;
  (0, _kea.resetContext)({
    createStore: true
  });
  const store = (0, _kea.getContext)().store;
  const unmountKibanaLogic = (0, _kibana.mountKibanaLogic)({
    application: core.application,
    capabilities: core.application.capabilities,
    config,
    data: plugins.data,
    lens: plugins.lens,
    productAccess,
    productFeatures,
    charts: plugins.charts,
    cloud: plugins.cloud,
    uiSettings: core.uiSettings,
    guidedOnboarding: plugins.guidedOnboarding,
    history: params.history,
    navigateToUrl: core.application.navigateToUrl,
    security: plugins.security,
    setBreadcrumbs: core.chrome.setBreadcrumbs,
    setChromeIsVisible: core.chrome.setIsVisible,
    setDocTitle: core.chrome.docTitle.change,
    renderHeaderActions: HeaderActions => params.setHeaderActionMenu(HeaderActions ? renderHeaderActions.bind(null, HeaderActions, store) : undefined)
  });
  const unmountLicensingLogic = (0, _licensing.mountLicensingLogic)({
    license$: plugins.licensing.license$,
    canManageLicense: (_core$application$cap = core.application.capabilities.management) === null || _core$application$cap === void 0 ? void 0 : (_core$application$cap2 = _core$application$cap.stack) === null || _core$application$cap2 === void 0 ? void 0 : _core$application$cap2.license_management
  });
  const unmountHttpLogic = (0, _http.mountHttpLogic)({
    http: core.http,
    errorConnectingMessage,
    readOnlyMode: initialData.readOnlyMode
  });
  const unmountFlashMessagesLogic = (0, _flash_messages.mountFlashMessagesLogic)();
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: params.theme$
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins
    }
  }, /*#__PURE__*/_react.default.createElement(CloudContext, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: params.history
  }, /*#__PURE__*/_react.default.createElement(App, initialData), /*#__PURE__*/_react.default.createElement(_flash_messages.Toasts, null))))))), params.element);
  return () => {
    _reactDom.default.unmountComponentAtNode(params.element);
    unmountKibanaLogic();
    unmountLicensingLogic();
    unmountHttpLogic();
    unmountFlashMessagesLogic();
    plugins.data.search.session.clear();
  };
};

/**
 * Render function for Kibana's header action menu chrome -
 * reusable by any Enterprise Search plugin simply by passing in
 * a custom HeaderActions component (e.g., WorkplaceSearchHeaderActions)
 * @see https://github.com/elastic/kibana/blob/main/docs/development/core/public/kibana-plugin-core-public.appmountparameters.setheaderactionmenu.md
 */
exports.renderApp = renderApp;
const renderHeaderActions = (HeaderActions, store, kibanaHeaderEl) => {
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(HeaderActions, null)), kibanaHeaderEl);
  return () => _reactDom.default.unmountComponentAtNode(kibanaHeaderEl);
};
exports.renderHeaderActions = renderHeaderActions;