"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _public = require("@kbn/cloud-chat-plugin/public");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _add_content_empty_prompt = require("../../../shared/add_content_empty_prompt");
var _doc_links = require("../../../shared/doc_links");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _telemetry = require("../../../shared/telemetry");
var _layout = require("../layout");
var _product_card = require("../product_card");
var _setup_guide = require("../setup_guide");
var _trial_callout = require("../trial_callout");
var _lock_light = _interopRequireDefault(require("./lock_light.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProductSelector = ({
  access,
  isWorkplaceSearchAdmin
}) => {
  const {
    hasAppSearchAccess,
    hasWorkplaceSearchAccess
  } = access;
  const {
    config
  } = (0, _kea.useValues)(_kibana.KibanaLogic);

  // If Enterprise Search hasn't been set up yet, show all products. Otherwise, only show products the user has access to
  const shouldShowAppSearchCard = !config.host && config.canDeployEntSearch || hasAppSearchAccess;
  const shouldShowWorkplaceSearchCard = !config.host && config.canDeployEntSearch || hasWorkplaceSearchAccess;

  // If Enterprise Search has been set up and the user does not have access to either product, show a message saying they
  // need to contact an administrator to get access to one of the products.
  const shouldShowEnterpriseSearchCards = shouldShowAppSearchCard || shouldShowWorkplaceSearchCard || !config.canDeployEntSearch;
  const WORKPLACE_SEARCH_URL = isWorkplaceSearchAdmin ? _constants.WORKPLACE_SEARCH_PLUGIN.URL : _constants.WORKPLACE_SEARCH_PLUGIN.NON_ADMIN_URL;
  const productCards = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_add_content_empty_prompt.AddContentEmptyPrompt, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.emptyPromptTitle', {
      defaultMessage: 'Add data and start searching'
    }),
    buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.overview.emptyPromptButtonLabel', {
      defaultMessage: 'Create an Elasticsearch index'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.productSelector.title', {
    defaultMessage: 'Search experiences for every use case'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
    "data-test-subj": "productCard-elasticsearch",
    cta: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.productCardCTA', {
      defaultMessage: 'View the setup guide'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.productCardDescription', {
      defaultMessage: 'Ideal for bespoke applications, Elasticsearch helps you build highly customizable search and offers many different ingestion methods.'
    }),
    features: [_i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.features.integrate', {
      defaultMessage: 'Integrate with databases, websites, and more'
    }), _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.features.buildTooling', {
      defaultMessage: 'Build custom tooling'
    }), _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.features.buildSearchExperiences', {
      defaultMessage: 'Build custom search experiences'
    })],
    emptyCta: true,
    icon: "logoElasticsearch",
    name: _constants.ELASTICSEARCH_PLUGIN.NAME,
    productId: _constants.ELASTICSEARCH_PLUGIN.ID,
    resourceLinks: [{
      label: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.resources.gettingStartedLabel', {
        defaultMessage: 'Getting started with Elasticsearch'
      }),
      to: _doc_links.docLinks.start
    }, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.resources.createNewIndexLabel', {
        defaultMessage: 'Create a new index'
      }),
      to: _doc_links.docLinks.start
    }, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.resources.languageClientLabel', {
        defaultMessage: 'Set up a language client'
      }),
      to: _doc_links.docLinks.languageClients
    }, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.resources.searchUILabel', {
        defaultMessage: 'Search UI for Elasticsearch'
      }),
      to: _doc_links.docLinks.searchUIElasticsearch
    }],
    url: _constants.ELASTICSEARCH_PLUGIN.URL
  })), shouldShowAppSearchCard && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
    "data-test-subj": "productCard-appSearch",
    cta: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.productCardCTA', {
      defaultMessage: 'Open App Search'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.productCardDescription', {
      defaultMessage: 'Ideal for apps and websites, App Search helps you design, deploy, and manage powerful search experiences.'
    }),
    features: [_i18n.i18n.translate('xpack.enterpriseSearch.appSearch.features.ingest', {
      defaultMessage: 'Ingest with a web crawler, API, or Elasticsearch'
    }), _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.features.managementDashboards', {
      defaultMessage: 'Search management dashboards'
    }), _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.features.searchApis', {
      defaultMessage: 'Search-optimized APIs'
    })],
    icon: "logoAppSearch",
    name: _constants.APP_SEARCH_PLUGIN.NAME,
    productId: _constants.APP_SEARCH_PLUGIN.ID,
    resourceLinks: [{
      label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.resources.gettingStartedLabel', {
        defaultMessage: 'Getting started with App Search'
      }),
      to: _doc_links.docLinks.appSearchGettingStarted
    }, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.resources.searchUILabel', {
        defaultMessage: 'Search UI for App Search'
      }),
      to: _doc_links.docLinks.searchUIAppSearch
    }, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.resources.searchRelevanceLabel', {
        defaultMessage: 'Tune your search relevance'
      }),
      to: _doc_links.docLinks.appSearchRelevance
    }, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.resources.adaptiveRelevanceLabel', {
        defaultMessage: 'Automate with Adaptive Relevance'
      }),
      to: _doc_links.docLinks.appSearchAdaptiveRelevance
    }],
    url: _constants.APP_SEARCH_PLUGIN.URL
  })), shouldShowWorkplaceSearchCard && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
    "data-test-subj": "productCard-workplaceSearch",
    cta: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.productCardCTA', {
      defaultMessage: 'Open Workplace Search'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.productCardDescription', {
      defaultMessage: 'Ideal for internal teams, Workplace Search helps unify your content in one place with instant connectivity to popular productivity tools.'
    }),
    features: [_i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.features.ingest', {
      defaultMessage: 'Ingest from third-party sources'
    }), _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.features.managementDashboards', {
      defaultMessage: 'Search management dashboards'
    }), _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.features.searchExperiences', {
      defaultMessage: 'Search experiences for authenticated users'
    })],
    icon: "logoWorkplaceSearch",
    name: _constants.WORKPLACE_SEARCH_PLUGIN.NAME,
    productId: _constants.WORKPLACE_SEARCH_PLUGIN.ID,
    resourceLinks: [{
      label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.resources.gettingStartedLabel', {
        defaultMessage: 'Getting started with Workplace Search'
      }),
      to: _doc_links.docLinks.workplaceSearchGettingStarted
    }, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.resources.setUpConnectorsLabel', {
        defaultMessage: 'Set up your connectors'
      }),
      to: _doc_links.docLinks.workplaceSearchContentSources
    }, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.resources.managePermissionsLabel', {
        defaultMessage: 'Manage permissions'
      }),
      to: _doc_links.docLinks.workplaceSearchPermissions
    }],
    url: WORKPLACE_SEARCH_URL
  })), !config.host && config.canDeployEntSearch && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuideCta, null))));
  const insufficientAccessMessage = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _lock_light.default,
      alt: ""
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.insufficientPermissionsTitle', {
      defaultMessage: 'Insufficient permissions'
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.insufficientPermissionsBody', {
      defaultMessage: 'You don’t have access to view this page. If you feel this may be an error, please contact your administrator.'
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: "/"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.insufficientPermissionsButtonLabel', {
      defaultMessage: 'Go to the Kibana dashboard'
    })),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.insufficientPermissionsFooterBody', {
      defaultMessage: 'Go to the Kibana dashboard'
    }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.kibanaSecurity,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.insufficientPermissionsFooterLinkLabel', {
      defaultMessage: 'Read documentation'
    })))
  });
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchOverviewPageTemplate, {
    restrictWidth: true,
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.overview.pageTitle', {
        defaultMessage: 'Welcome to Enterprise Search'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetEnterpriseSearchChrome, null), /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "viewed",
    metric: "overview"
  }), /*#__PURE__*/_react.default.createElement(_trial_callout.TrialCallout, null), shouldShowEnterpriseSearchCards ? productCards : insufficientAccessMessage, /*#__PURE__*/_react.default.createElement(_public.Chat, null));
};
exports.ProductSelector = ProductSelector;