"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncStatusToColor = syncStatusToColor;
exports.syncStatusToText = syncStatusToText;
var _i18n = require("@kbn/i18n");
var _connectors = require("../../../../common/types/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function syncStatusToText(status) {
  switch (status) {
    case _connectors.SyncStatus.COMPLETED:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.syncStatus.completed', {
        defaultMessage: 'Sync complete'
      });
    case _connectors.SyncStatus.ERROR:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.syncStatus.error', {
        defaultMessage: 'Sync failure'
      });
    case _connectors.SyncStatus.IN_PROGRESS:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.syncStatus.inProgress', {
        defaultMessage: 'Sync in progress'
      });
    case _connectors.SyncStatus.CANCELED:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.syncStatus.canceling', {
        defaultMessage: 'Sync canceled'
      });
    case _connectors.SyncStatus.CANCELING:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.syncStatus.canceled', {
        defaultMessage: 'Canceling sync'
      });
    case _connectors.SyncStatus.PENDING:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.syncStatus.pending', {
        defaultMessage: 'Sync pending'
      });
    case _connectors.SyncStatus.SUSPENDED:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.syncStatus.suspended', {
        defaultMessage: 'Sync suspended'
      });
  }
}
function syncStatusToColor(status) {
  switch (status) {
    case _connectors.SyncStatus.COMPLETED:
      return 'success';
    case _connectors.SyncStatus.ERROR:
    case _connectors.SyncStatus.CANCELED:
      return 'danger';
    case _connectors.SyncStatus.IN_PROGRESS:
    case _connectors.SyncStatus.PENDING:
    case _connectors.SyncStatus.SUSPENDED:
    case _connectors.SyncStatus.CANCELING:
      return 'warning';
  }
}