"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIVERSAL_LANGUAGE_VALUE = void 0;
exports.languageToText = languageToText;
exports.languageToTextMap = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNIVERSAL_LANGUAGE_VALUE = '';
exports.UNIVERSAL_LANGUAGE_VALUE = UNIVERSAL_LANGUAGE_VALUE;
const languageToTextMap = {
  [UNIVERSAL_LANGUAGE_VALUE]: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.universalLabel', {
    defaultMessage: 'Universal'
  }),
  da: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.danishLabel', {
    defaultMessage: 'Danish'
  }),
  de: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.germanLabel', {
    defaultMessage: 'German'
  }),
  en: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.englishLabel', {
    defaultMessage: 'English'
  }),
  es: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.spanishLabel', {
    defaultMessage: 'Spanish'
  }),
  fr: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.frenchLabel', {
    defaultMessage: 'French'
  }),
  it: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.italianLabel', {
    defaultMessage: 'Italian'
  }),
  ja: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.japaneseLabel', {
    defaultMessage: 'Japanese'
  }),
  ko: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.koreanLabel', {
    defaultMessage: 'Korean'
  }),
  nl: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.dutchLabel', {
    defaultMessage: 'Dutch'
  }),
  pt: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.portugueseLabel', {
    defaultMessage: 'Portuguese'
  }),
  'pt-br': _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.portugueseBrazilLabel', {
    defaultMessage: 'Portuguese (Brazil)'
  }),
  ru: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.russianLabel', {
    defaultMessage: 'Russian'
  }),
  th: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.thaiLabel', {
    defaultMessage: 'Thai'
  }),
  zh: _i18n.i18n.translate('xpack.enterpriseSearch.content.supportedLanguages.chineseLabel', {
    defaultMessage: 'Chinese'
  })
};
exports.languageToTextMap = languageToTextMap;
function languageToText(input) {
  var _languageToTextMap$in;
  return (_languageToTextMap$in = languageToTextMap[input]) !== null && _languageToTextMap$in !== void 0 ? _languageToTextMap$in : input;
}