"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filteringPolicyToText = filteringPolicyToText;
exports.filteringRuleToText = filteringRuleToText;
var _i18n = require("@kbn/i18n");
var _connectors = require("../../../../common/types/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filteringRuleStringMap = {
  [_connectors.FilteringRuleRule.CONTAINS]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.rules.contains', {
    defaultMessage: 'Contains'
  }),
  [_connectors.FilteringRuleRule.ENDS_WITH]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.rules.endsWith', {
    defaultMessage: 'Ends with'
  }),
  [_connectors.FilteringRuleRule.EQUALS]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.rules.equals', {
    defaultMessage: 'Equals'
  }),
  [_connectors.FilteringRuleRule.GT]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.rules.greaterThan', {
    defaultMessage: 'Greater than'
  }),
  [_connectors.FilteringRuleRule.LT]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.rules.lessThan', {
    defaultMessage: 'Less than'
  }),
  [_connectors.FilteringRuleRule.REGEX]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.rules.regEx', {
    defaultMessage: 'Regular expression'
  }),
  [_connectors.FilteringRuleRule.STARTS_WITH]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.rules.startsWith', {
    defaultMessage: 'Starts with'
  })
};
function filteringRuleToText(filteringRule) {
  return filteringRuleStringMap[filteringRule];
}
const filteringPolicyStringMap = {
  [_connectors.FilteringPolicy.EXCLUDE]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.policy.exclude', {
    defaultMessage: 'Exclude'
  }),
  [_connectors.FilteringPolicy.INCLUDE]: _i18n.i18n.translate('xpack.enterpriseSearch.content.filteringRules.policy.include', {
    defaultMessage: 'Include'
  })
};
function filteringPolicyToText(filteringPolicy) {
  return filteringPolicyStringMap[filteringPolicy];
}