"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SettingsPanel = ({
  description,
  label,
  link,
  onChange,
  title,
  value
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
  hasBorder: true,
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "m"
}, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement("strong", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, description), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contentExtraction.descriptionTwo', {
  defaultMessage: 'You can also enable or disable this feature for a specific index on the index’s configuration page.'
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
  grow: false,
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
  checked: value,
  label: label,
  onChange: onChange
})), link && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, link))));
exports.SettingsPanel = SettingsPanel;