"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../common/types/api");
var _fetch_sync_jobs_stats_api_logic = require("../../api/stats/fetch_sync_jobs_stats_api_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicesStats = () => {
  var _data$connected, _data$incomplete, _data$in_progress, _data$idle, _data$orphaned_jobs, _data$errors;
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_sync_jobs_stats_api_logic.FetchSyncJobsStatsApiLogic);
  const {
    data,
    status
  } = (0, _kea.useValues)(_fetch_sync_jobs_stats_api_logic.FetchSyncJobsStatsApiLogic);
  const isLoading = status === _api.Status.LOADING;
  (0, _react.useEffect)(() => {
    makeRequest({});
  }, []);
  const UNKNOWN_STRING = _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.jobStats.unknown', {
    defaultMessage: 'Unknown'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: data !== null && data !== void 0 && data.connected ? 'success' : 'subdued',
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "m",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.jobStats.connectedMethods', {
      defaultMessage: 'Connected ingest methods'
    }),
    isLoading: isLoading,
    title: (_data$connected = data === null || data === void 0 ? void 0 : data.connected) !== null && _data$connected !== void 0 ? _data$connected : UNKNOWN_STRING
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: data !== null && data !== void 0 && data.incomplete ? 'warning' : 'subdued',
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "m",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.jobStats.incompleteMethods', {
      defaultMessage: 'Incomplete ingest methods'
    }),
    isLoading: isLoading,
    title: (_data$incomplete = data === null || data === void 0 ? void 0 : data.incomplete) !== null && _data$incomplete !== void 0 ? _data$incomplete : UNKNOWN_STRING
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "m",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.jobStats.runningSyncs', {
      defaultMessage: 'Running syncs'
    }),
    isLoading: isLoading,
    title: (_data$in_progress = data === null || data === void 0 ? void 0 : data.in_progress) !== null && _data$in_progress !== void 0 ? _data$in_progress : UNKNOWN_STRING
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: data !== null && data !== void 0 && data.idle ? 'warning' : 'subdued',
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "m",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.jobStats.longRunningSyncs', {
      defaultMessage: 'Idle syncs'
    }),
    isLoading: isLoading,
    title: (_data$idle = data === null || data === void 0 ? void 0 : data.idle) !== null && _data$idle !== void 0 ? _data$idle : UNKNOWN_STRING
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: data !== null && data !== void 0 && data.orphaned_jobs ? 'warning' : 'subdued',
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "m",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.jobStats.orphanedSyncs', {
      defaultMessage: 'Orphaned syncs'
    }),
    isLoading: isLoading,
    title: (_data$orphaned_jobs = data === null || data === void 0 ? void 0 : data.orphaned_jobs) !== null && _data$orphaned_jobs !== void 0 ? _data$orphaned_jobs : UNKNOWN_STRING
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: data !== null && data !== void 0 && data.errors ? 'danger' : 'subdued',
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "m",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.jobStats.errorSyncs', {
      defaultMessage: 'Syncs errors'
    }),
    isLoading: isLoading,
    title: (_data$errors = data === null || data === void 0 ? void 0 : data.errors) !== null && _data$errors !== void 0 ? _data$errors : UNKNOWN_STRING
  }))))));
};
exports.IndicesStats = IndicesStats;