"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobsViewLogic = void 0;
var _kea = require("kea");
var _moment = _interopRequireDefault(require("moment"));
var _api = require("../../../../../../common/types/api");
var _fetch_sync_jobs_api_logic = require("../../../api/connector/fetch_sync_jobs_api_logic");
var _index_view_logic = require("../index_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncJobsViewLogic = (0, _kea.kea)({
  actions: {},
  connect: {
    actions: [_fetch_sync_jobs_api_logic.FetchSyncJobsApiLogic, ['apiError as fetchSyncJobsError', 'apiReset as resetFetchSyncJobsIndexApi', 'apiSuccess as fetchSyncJobsApiSuccess', 'makeRequest as fetchSyncJobs']],
    values: [_index_view_logic.IndexViewLogic, ['connectorId'], _fetch_sync_jobs_api_logic.FetchSyncJobsApiLogic, ['data as syncJobsData', 'status as syncJobsStatus']]
  },
  path: ['enterprise_search', 'content', 'sync_jobs_view_logic'],
  selectors: ({
    selectors
  }) => ({
    syncJobs: [() => [selectors.syncJobsData], data => {
      var _data$data$map;
      return (_data$data$map = data === null || data === void 0 ? void 0 : data.data.map(syncJob => {
        var _syncJob$completed_at;
        return {
          ...syncJob,
          duration: syncJob.completed_at ? _moment.default.duration((0, _moment.default)(syncJob.completed_at).diff((0, _moment.default)(syncJob.created_at))) : syncJob.started_at ? _moment.default.duration((0, _moment.default)(new Date()).diff((0, _moment.default)(syncJob.started_at))) : undefined,
          lastSync: (_syncJob$completed_at = syncJob.completed_at) !== null && _syncJob$completed_at !== void 0 ? _syncJob$completed_at : syncJob.created_at
        };
      })) !== null && _data$data$map !== void 0 ? _data$data$map : [];
    }],
    syncJobsLoading: [() => [selectors.syncJobsStatus], status => status === _api.Status.IDLE || status === _api.Status.LOADING],
    syncJobsPagination: [() => [selectors.syncJobsData], data => data ? data._meta.page : {
      from: 0,
      has_more_hits_than_total: false,
      size: 10,
      total: 0
    }]
  })
});
exports.SyncJobsViewLogic = SyncJobsViewLogic;