"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilteringPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filtering_rules_table = require("../../shared/filtering_rules_table/filtering_rules_table");
var _flyout_panel = require("./flyout_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilteringPanel = ({
  advancedSnippet,
  filteringRules
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_panel.FlyoutPanel, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.syncRulesTitle', {
      defaultMessage: 'Sync rules'
    })
  }, /*#__PURE__*/_react.default.createElement(_filtering_rules_table.FilteringRulesTable, {
    filteringRules: filteringRules,
    showOrder: false
  })), !!(advancedSnippet !== null && advancedSnippet !== void 0 && advancedSnippet.value) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_flyout_panel.FlyoutPanel, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.syncRulesAdvancedTitle', {
      defaultMessage: 'Advanced sync rules'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    transparentBackground: true,
    language: "json"
  }, JSON.stringify(advancedSnippet.value, undefined, 2))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null));
};
exports.FilteringPanel = FilteringPanel;