"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobDocumentsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _flyout_panel = require("./flyout_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncJobDocumentsPanel = syncJobDocuments => {
  const columns = [{
    field: 'added',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.documents.added', {
      defaultMessage: 'Added'
    })
  }, {
    field: 'removed',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.documents.removed', {
      defaultMessage: 'Removed'
    })
  }, {
    field: 'total',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.documents.total', {
      defaultMessage: 'Total'
    })
  }, {
    field: 'volume',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.documents.volume', {
      defaultMessage: 'Volume'
    }),
    render: volume => volume < 1 ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.documents.volume.lessThanOneMBLabel', {
      defaultMessage: 'Less than 1mb'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.documents.volume.aboutLabel', {
      defaultMessage: 'About {volume}',
      values: {
        volume: new _configSchema.ByteSizeValue(volume * 1024 * 1024).toString()
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_flyout_panel.FlyoutPanel, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.documents.title', {
      defaultMessage: 'Documents'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: [syncJobDocuments]
  }));
};
exports.SyncJobDocumentsPanel = SyncJobDocumentsPanel;