"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexTabId = exports.SearchIndex = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _indices = require("../../utils/indices");
var _page_template = require("../layout/page_template");
var _search_indices = require("../search_indices");
var _header_actions = require("./components/header_actions/header_actions");
var _connector_configuration = require("./connector/connector_configuration");
var _connector_scheduling = require("./connector/connector_scheduling");
var _connector_rules = require("./connector/sync_rules/connector_rules");
var _automatic_crawl_scheduler = require("./crawler/automatic_crawl_scheduler/automatic_crawl_scheduler");
var _crawl_custom_settings_flyout = require("./crawler/crawl_custom_settings_flyout/crawl_custom_settings_flyout");
var _crawler_configuration = require("./crawler/crawler_configuration/crawler_configuration");
var _domain_management = require("./crawler/domain_management/domain_management");
var _no_connector_record = require("./crawler/no_connector_record");
var _documents = require("./documents");
var _index_mappings = require("./index_mappings");
var _index_name_logic = require("./index_name_logic");
var _index_view_logic = require("./index_view_logic");
var _overview = require("./overview");
var _pipelines = require("./pipelines/pipelines");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SearchIndexTabId;
exports.SearchIndexTabId = SearchIndexTabId;
(function (SearchIndexTabId) {
  SearchIndexTabId["OVERVIEW"] = "overview";
  SearchIndexTabId["DOCUMENTS"] = "documents";
  SearchIndexTabId["INDEX_MAPPINGS"] = "index_mappings";
  SearchIndexTabId["PIPELINES"] = "pipelines";
  SearchIndexTabId["CONFIGURATION"] = "configuration";
  SearchIndexTabId["SYNC_RULES"] = "sync_rules";
  SearchIndexTabId["SCHEDULING"] = "scheduling";
  SearchIndexTabId["DOMAIN_MANAGEMENT"] = "domain_management";
  SearchIndexTabId["CRAWLER_CONFIGURATION"] = "crawler_configuration";
})(SearchIndexTabId || (exports.SearchIndexTabId = SearchIndexTabId = {}));
const SearchIndex = () => {
  const {
    hasFilteringFeature,
    index,
    isInitialLoading
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    tabId = SearchIndexTabId.OVERVIEW
  } = (0, _reactRouterDom.useParams)();
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);

  /**
   * Guided Onboarding needs us to mark the add data step as complete as soon as the user has data in an index.
   * This needs to be checked for any of the 3 registered search guideIds
   * Putting it here guarantees that if a user is viewing an index with data, it'll be marked as complete
   */
  const {
    guidedOnboarding,
    productAccess: {
      hasAppSearchAccess
    },
    productFeatures: {
      hasDefaultIngestPipeline
    }
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const isAppGuideActive = (0, _useObservable.default)(guidedOnboarding.guidedOnboardingApi.isGuideStepActive$('appSearch', 'add_data'));
  const isWebsiteGuideActive = (0, _useObservable.default)(guidedOnboarding.guidedOnboardingApi.isGuideStepActive$('websiteSearch', 'add_data'));
  const isDatabaseGuideActive = (0, _useObservable.default)(guidedOnboarding.guidedOnboardingApi.isGuideStepActive$('databaseSearch', 'add_data'));
  (0, _react.useEffect)(() => {
    if (isAppGuideActive && index !== null && index !== void 0 && index.count) {
      var _guidedOnboarding$gui;
      (_guidedOnboarding$gui = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui === void 0 ? void 0 : _guidedOnboarding$gui.completeGuideStep('appSearch', 'add_data');
    } else if (isWebsiteGuideActive && index !== null && index !== void 0 && index.count) {
      var _guidedOnboarding$gui2;
      (_guidedOnboarding$gui2 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui2 === void 0 ? void 0 : _guidedOnboarding$gui2.completeGuideStep('websiteSearch', 'add_data');
    } else if (isDatabaseGuideActive && index !== null && index !== void 0 && index.count) {
      var _guidedOnboarding$gui3;
      (_guidedOnboarding$gui3 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui3 === void 0 ? void 0 : _guidedOnboarding$gui3.completeGuideStep('databaseSearch', 'add_data');
    }
  }, [isAppGuideActive, isWebsiteGuideActive, isDatabaseGuideActive, index === null || index === void 0 ? void 0 : index.count]);
  const ALL_INDICES_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_overview.SearchIndexOverview, null),
    id: SearchIndexTabId.OVERVIEW,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.overviewTabLabel', {
      defaultMessage: 'Overview'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_documents.SearchIndexDocuments, null),
    id: SearchIndexTabId.DOCUMENTS,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documentsTabLabel', {
      defaultMessage: 'Documents'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_index_mappings.SearchIndexIndexMappings, null),
    id: SearchIndexTabId.INDEX_MAPPINGS,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.indexMappingsTabLabel', {
      defaultMessage: 'Index mappings'
    })
  }];
  const CONNECTOR_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_connector_configuration.ConnectorConfiguration, null),
    id: SearchIndexTabId.CONFIGURATION,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.configurationTabLabel', {
      defaultMessage: 'Configuration'
    })
  }, ...(hasFilteringFeature ? [{
    content: /*#__PURE__*/_react.default.createElement(_connector_rules.ConnectorSyncRules, null),
    id: SearchIndexTabId.SYNC_RULES,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.syncRulesTabLabel', {
      defaultMessage: 'Sync rules'
    })
  }] : []), {
    content: /*#__PURE__*/_react.default.createElement(_connector_scheduling.ConnectorSchedulingComponent, null),
    id: SearchIndexTabId.SCHEDULING,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.schedulingTabLabel', {
      defaultMessage: 'Scheduling'
    })
  }];
  const CRAWLER_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_domain_management.SearchIndexDomainManagement, null),
    id: SearchIndexTabId.DOMAIN_MANAGEMENT,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.domainManagementTabLabel', {
      defaultMessage: 'Manage Domains'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_crawler_configuration.CrawlerConfiguration, null),
    id: SearchIndexTabId.CRAWLER_CONFIGURATION,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.crawlerConfigurationTabLabel', {
      defaultMessage: 'Configuration'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_automatic_crawl_scheduler.AutomaticCrawlScheduler, null),
    id: SearchIndexTabId.SCHEDULING,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.schedulingTabLabel', {
      defaultMessage: 'Scheduling'
    })
  }];
  const PIPELINES_TAB = {
    content: /*#__PURE__*/_react.default.createElement(_pipelines.SearchIndexPipelines, null),
    id: SearchIndexTabId.PIPELINES,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.pipelinesTabLabel', {
      defaultMessage: 'Pipelines'
    })
  };
  const tabs = [...ALL_INDICES_TABS, ...((0, _indices.isConnectorIndex)(index) ? CONNECTOR_TABS : []), ...((0, _indices.isCrawlerIndex)(index) ? CRAWLER_TABS : []), ...(hasDefaultIngestPipeline ? [PIPELINES_TAB] : [])];
  const selectedTab = tabs.find(tab => tab.id === tabId);
  const onTabClick = tab => {
    _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(tab.id === SearchIndexTabId.OVERVIEW ? _routes.SEARCH_INDEX_PATH : _routes.SEARCH_INDEX_TAB_PATH, {
      indexName,
      tabId: tab.id
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._search_indices.baseBreadcrumbs, indexName],
    pageViewTelemetry: tabId,
    isLoading: isInitialLoading,
    pageHeader: {
      pageTitle: indexName,
      rightSideItems: (0, _header_actions.getHeaderActions)(index, hasAppSearchAccess)
    }
  }, (0, _indices.isCrawlerIndex)(index) && !index.connector ? /*#__PURE__*/_react.default.createElement(_no_connector_record.NoConnectorRecord, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indexName === (index === null || index === void 0 ? void 0 : index.name) && /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    selectedTab: selectedTab,
    onTabClick: onTabClick
  }), (0, _indices.isCrawlerIndex)(index) && /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout.CrawlCustomSettingsFlyout, null)));
};
exports.SearchIndex = SearchIndex;