"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesJSONConfigurations = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _data_panel = require("../../../../shared/data_panel/data_panel");
var _doc_links = require("../../../../shared/doc_links");
var _http = require("../../../../shared/http");
var _is_managed = require("../../../../shared/pipelines/is_managed");
var _index_view_logic = require("../index_view_logic");
var _pipeline_json_badges = require("./pipeline_json_badges");
var _pipelines_json_configurations_logic = require("./pipelines_json_configurations_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelinesJSONConfigurations = () => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    pipelineNames,
    selectedPipeline,
    selectedPipelineId,
    selectedPipelineJSON
  } = (0, _kea.useValues)(_pipelines_json_configurations_logic.IndexPipelinesConfigurationsLogic);
  const {
    selectPipeline
  } = (0, _kea.useActions)(_pipelines_json_configurations_logic.IndexPipelinesConfigurationsLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.title', {
      defaultMessage: 'Pipeline configurations'
    })),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.subtitle', {
      defaultMessage: 'View the JSON for your pipeline configurations on this index.'
    }),
    footerDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.ingestPipelines,
      target: "_blank",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.ingestionPipelines.docLink', {
      defaultMessage: 'Learn more about how Enterprise Search uses ingest pipelines'
    })),
    action: pipelineNames.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m"
    }, pipelineNames.length),
    iconType: "visVega"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.selectLabel', {
      defaultMessage: 'Select an ingest pipeline to view'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-selectPipeline`,
    fullWidth: true,
    options: pipelineNames.map(name => ({
      text: name,
      value: name
    })),
    value: selectedPipelineId,
    onChange: e => selectPipeline(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), selectedPipeline && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_pipeline_json_badges.PipelineJSONBadges, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, (0, _is_managed.isManagedPipeline)(selectedPipeline) ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-viewInStackManagement`,
    size: "s",
    flush: "both",
    iconType: "eye",
    color: "primary",
    href: http.basePath.prepend(`/app/management/ingest/ingest_pipelines/?pipeline=${selectedPipelineId}`)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.action.view', {
    defaultMessage: 'View in Stack Management'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-editInStackManagement`,
    size: "s",
    flush: "both",
    iconType: "pencil",
    color: "primary",
    href: http.basePath.prepend(`/app/management/ingest/ingest_pipelines/edit/${selectedPipelineId}`)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.action.edit', {
    defaultMessage: 'Edit in Stack Management'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    overflowHeight: 300,
    isCopyable: true
  }, selectedPipelineJSON))));
};
exports.PipelinesJSONConfigurations = PipelinesJSONConfigurations;