"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexPipelines = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _constants = require("../../../../shared/constants");
var _data_panel = require("../../../../shared/data_panel/data_panel");
var _doc_links = require("../../../../shared/doc_links");
var _revert_connector_pipeline_api_logic = require("../../../api/pipelines/revert_connector_pipeline_api_logic");
var _indices = require("../../../utils/indices");
var _index_name_logic = require("../index_name_logic");
var _inference_errors = require("./inference_errors");
var _inference_history = require("./inference_history");
var _customize_pipeline_item = require("./ingest_pipelines/customize_pipeline_item");
var _ingest_pipelines_card = require("./ingest_pipelines/ingest_pipelines_card");
var _manage_custom_pipeline_actions = require("./ingest_pipelines/manage_custom_pipeline_actions");
var _add_inference_pipeline_flyout = require("./ml_inference/add_inference_pipeline_flyout");
var _ml_inference_pipeline_processors_card = require("./ml_inference_pipeline_processors_card");
var _pipelines_json_configurations = require("./pipelines_json_configurations");
var _pipelines_logic = require("./pipelines_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexPipelines = () => {
  const {
    showMissingPipelineCallout,
    showAddMlInferencePipelineModal,
    hasIndexIngestionPipeline,
    index,
    isDeleteModalOpen,
    pipelineName
  } = (0, _kea.useValues)(_pipelines_logic.PipelinesLogic);
  const {
    closeAddMlInferencePipelineModal,
    closeDeleteModal
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    status: revertStatus
  } = (0, _kea.useValues)(_revert_connector_pipeline_api_logic.RevertConnectorPipelineApilogic);
  const {
    makeRequest: revertPipeline
  } = (0, _kea.useActions)(_revert_connector_pipeline_api_logic.RevertConnectorPipelineApilogic);
  const apiIndex = (0, _indices.isApiIndex)(index);
  const pipelinesTabs = [{
    content: /*#__PURE__*/_react.default.createElement(_inference_history.InferenceHistory, null),
    id: 'inference-history',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory', {
      defaultMessage: 'Inference history'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_pipelines_json_configurations.PipelinesJSONConfigurations, null),
    id: 'json-configurations',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations', {
      defaultMessage: 'JSON configurations'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), showMissingPipelineCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.missingPipeline.title', {
      defaultMessage: 'Custom pipeline missing'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.missingPipeline.description', {
    defaultMessage: 'The custom pipeline for this index has been deleted. This may affect connector data ingestion. Its configuration will need to be reverted to the default pipeline settings.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true,
    onClick: () => revertPipeline({
      indexName
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.missingPipeline.buttonLabel', {
    defaultMessage: 'Revert pipeline to default'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_customize_pipeline_item.CopyAndCustomizePipelinePanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    footerDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.ingestPipelines,
      target: "_blank",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.docLink', {
      defaultMessage: 'Learn more about using pipelines in Enterprise Search'
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.title', {
      defaultMessage: 'Ingest Pipelines'
    })),
    subtitle: apiIndex ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.apiIndexSubtitle', {
      defaultMessage: "Ingest pipelines optimize your index for search applications. If you'd like to use these pipelines in your API-based index, you'll need to reference them explicitly in your API requests."
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.subtitle', {
      defaultMessage: 'Ingest pipelines optimize your index for search applications'
    }),
    iconType: "logstashInput",
    action: hasIndexIngestionPipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.customBadge', {
      defaultMessage: 'Custom'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_manage_custom_pipeline_actions.ManageCustomPipelineActions, null))) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.defaultBadge', {
      defaultMessage: 'Default'
    }))
  }, /*#__PURE__*/_react.default.createElement(_ingest_pipelines_card.IngestPipelinesCard, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    footerDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.deployTrainedModels,
      target: "_blank",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInferencePipelines.docLink', {
      defaultMessage: 'Learn more about deploying Machine Learning models in Elastic'
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInferencePipelines.title', {
      defaultMessage: 'Machine Learning Inference Pipelines'
    })),
    subtitle: apiIndex && hasIndexIngestionPipeline ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInferencePipelines.subtitleAPIindex', {
      defaultMessage: "Inference pipelines will be run as processors from the Enterprise Search Ingest Pipeline. In order to use these pipelines on API-based indices you'll need to reference the {pipelineName} pipeline in your API requests.",
      values: {
        pipelineName
      }
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInferencePipelines.subtitle', {
      defaultMessage: 'Inference pipelines will be run as processors from the Enterprise Search Ingest Pipeline'
    }),
    iconType: "compute"
  }, /*#__PURE__*/_react.default.createElement(_ml_inference_pipeline_processors_card.MlInferencePipelineProcessorsCard, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: pipelinesTabs,
    initialSelectedTab: pipelinesTabs[0],
    autoFocus: "selected"
  })))), /*#__PURE__*/_react.default.createElement(_inference_errors.InferenceErrors, null), showAddMlInferencePipelineModal && /*#__PURE__*/_react.default.createElement(_add_inference_pipeline_flyout.AddInferencePipelineFlyout, {
    onClose: closeAddMlInferencePipelineModal
  }), isDeleteModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.deleteModal.title', {
      defaultMessage: 'Delete custom pipeline'
    }),
    isLoading: revertStatus === _api.Status.LOADING,
    onCancel: closeDeleteModal,
    onConfirm: () => revertPipeline({
      indexName
    }),
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.deleteModal.confirmButton', {
      defaultMessage: 'Delete pipeline'
    }),
    buttonColor: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.deleteModal.description', {
    defaultMessage: 'This will delete any custom pipelines associated with this index, including machine learning inference pipelines. The index will revert to using the default ingest pipeline.'
  }))));
};
exports.SearchIndexPipelines = SearchIndexPipelines;