"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineSettingsForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _settings_checkable_card = require("../../shared/settings_checkable_card/settings_checkable_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineSettingsForm = ({
  ingestionMethod,
  setPipeline,
  pipeline
}) => {
  const {
    extract_binary_content: extractBinaryContent,
    reduce_whitespace: reduceWhitespace,
    run_ml_inference: runMLInference
  } = pipeline;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_settings_checkable_card.SettingsCheckableCard, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-extractBinaryContent`,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.extractBinaryDescription', {
      defaultMessage: 'Extract content from images and PDF files'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.extractBinaryLabel', {
      defaultMessage: 'Content extraction'
    }),
    onChange: () => setPipeline({
      ...pipeline,
      extract_binary_content: !pipeline.extract_binary_content
    }),
    checked: extractBinaryContent,
    id: "ingestPipelineExtractBinaryContent"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_settings_checkable_card.SettingsCheckableCard, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-reduceWhitespace`,
    id: "ingestPipelineReduceWhitespace",
    checked: reduceWhitespace,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.reduceWhitespaceDescription', {
      defaultMessage: 'Trim extra whitespace from your documents automatically'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.reduceWhitespaceLabel', {
      defaultMessage: 'Reduce whitespace'
    }),
    onChange: () => setPipeline({
      ...pipeline,
      reduce_whitespace: !pipeline.reduce_whitespace
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_settings_checkable_card.SettingsCheckableCard, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-runMlInference`,
    id: "ingestPipelineRunMlInference",
    checked: runMLInference,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.runMlInferenceDescrition', {
      defaultMessage: 'Enhance your data using compatible trained ML models'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.mlInferenceLabel', {
      defaultMessage: 'ML Inference Pipelines'
    }),
    onChange: () => setPipeline({
      ...pipeline,
      run_ml_inference: !pipeline.run_ml_inference
    })
  })));
};
exports.PipelineSettingsForm = PipelineSettingsForm;