"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePipelineNameIsAvailable = exports.validateInferencePipelineFields = exports.validateInferencePipelineConfiguration = exports.isValidPipelineName = exports.getDisabledReason = exports.MODEL_SELECT_PLACEHOLDER = exports.MODEL_REDACTED_VALUE = exports.EXISTING_PIPELINE_DISABLED_TEXT_EXPANSION = exports.EXISTING_PIPELINE_DISABLED_PIPELINE_EXISTS = exports.EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELD = void 0;
var _i18n = require("@kbn/i18n");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VALID_PIPELINE_NAME_REGEX = /^[\w\-]+$/;
const isValidPipelineName = input => {
  return input.length > 0 && VALID_PIPELINE_NAME_REGEX.test(input);
};
exports.isValidPipelineName = isValidPipelineName;
const INVALID_PIPELINE_NAME_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.invalidPipelineName', {
  defaultMessage: 'Name must only contain letters, numbers, underscores, and hyphens.'
});
const FIELD_REQUIRED_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.emptyValueError', {
  defaultMessage: 'Field is required.'
});
const PIPELINE_NAME_EXISTS_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.pipelineNameExistsError', {
  defaultMessage: 'Name already used by another pipeline.'
});
const validateInferencePipelineConfiguration = config => {
  const errors = {};
  if (config.existingPipeline === true) {
    if (config.pipelineName.length === 0) {
      errors.pipelineName = FIELD_REQUIRED_ERROR;
    }
    return errors;
  }
  if (config.pipelineName.trim().length === 0) {
    errors.pipelineName = FIELD_REQUIRED_ERROR;
  } else if (!isValidPipelineName(config.pipelineName)) {
    errors.pipelineName = INVALID_PIPELINE_NAME_ERROR;
  }
  if (config.modelID.trim().length === 0) {
    errors.modelID = FIELD_REQUIRED_ERROR;
  }
  return errors;
};
exports.validateInferencePipelineConfiguration = validateInferencePipelineConfiguration;
const validatePipelineNameIsAvailable = existingPipeline => {
  const errors = {};
  if (existingPipeline !== undefined) {
    errors.pipelineName = PIPELINE_NAME_EXISTS_ERROR;
  }
  return errors;
};
exports.validatePipelineNameIsAvailable = validatePipelineNameIsAvailable;
const validateInferencePipelineFields = config => {
  const errors = {};

  // If there are field mappings, we don't need to validate the single source field
  if (config.fieldMappings && Object.keys(config.fieldMappings).length > 0) {
    return errors;
  }
  if (config.sourceField.trim().length === 0) {
    errors.sourceField = FIELD_REQUIRED_ERROR;
  }
  return errors;
};
exports.validateInferencePipelineFields = validateInferencePipelineFields;
const EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELD = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipeline.disabledSourceFieldDescription', {
  defaultMessage: 'This pipeline cannot be selected because the source field does not exist on this index.'
});
exports.EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELD = EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELD;
const EXISTING_PIPELINE_DISABLED_PIPELINE_EXISTS = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipeline.disabledPipelineExistsDescription', {
  defaultMessage: 'This pipeline cannot be selected because it is already attached.'
});
exports.EXISTING_PIPELINE_DISABLED_PIPELINE_EXISTS = EXISTING_PIPELINE_DISABLED_PIPELINE_EXISTS;
const EXISTING_PIPELINE_DISABLED_TEXT_EXPANSION = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipeline.disabledElserNotSupportedDescription', {
  defaultMessage: 'This pipeline cannot be selected because attaching an ELSER pipeline is not supported yet.'
});
exports.EXISTING_PIPELINE_DISABLED_TEXT_EXPANSION = EXISTING_PIPELINE_DISABLED_TEXT_EXPANSION;
const getDisabledReason = (sourceFields, sourceField, indexProcessorNames, pipelineName, modelType) => {
  var _sourceFields$include;
  if (!((_sourceFields$include = sourceFields === null || sourceFields === void 0 ? void 0 : sourceFields.includes(sourceField)) !== null && _sourceFields$include !== void 0 ? _sourceFields$include : false)) {
    return EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELD;
  } else if (indexProcessorNames.includes(pipelineName)) {
    return EXISTING_PIPELINE_DISABLED_PIPELINE_EXISTS;
  } else if (modelType === _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EXPANSION) {
    return EXISTING_PIPELINE_DISABLED_TEXT_EXPANSION;
  }
  return undefined;
};
exports.getDisabledReason = getDisabledReason;
const MODEL_SELECT_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.model.placeholder', {
  defaultMessage: 'Select a model'
});
exports.MODEL_SELECT_PLACEHOLDER = MODEL_SELECT_PLACEHOLDER;
const MODEL_REDACTED_VALUE = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.model.redactedValue', {
  defaultMessage: "This model isn't available in the Kibana space"
});
exports.MODEL_REDACTED_VALUE = MODEL_REDACTED_VALUE;