"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextExpansionDismissButton = exports.TextExpansionCallOut = exports.ModelStarted = exports.ModelDeploymentInProgress = exports.ModelDeployed = exports.FineTuneModelsButton = exports.DeployModel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
var _kibana = require("../../../../../shared/kibana");
var _index_view_logic = require("../../index_view_logic");
var _text_expansion_callout_data = require("./text_expansion_callout_data");
var _text_expansion_callout_logic = require("./text_expansion_callout_logic");
var _text_expansion_errors = require("./text_expansion_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRAINED_MODELS_PATH = '/app/ml/trained_models';
const TextExpansionDismissButton = ({
  dismiss
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.dismissButton', {
      defaultMessage: 'Dismiss ELSER call out'
    }),
    iconType: "cross",
    onClick: dismiss
  });
};
exports.TextExpansionDismissButton = TextExpansionDismissButton;
const FineTuneModelsButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconSide: "left",
  iconType: "wrench",
  onClick: () => _kibana.KibanaLogic.values.navigateToUrl(TRAINED_MODELS_PATH, {
    shouldNotCreateHref: true
  })
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCallOut.fineTuneModelButton', {
  defaultMessage: 'Fine-tune performance'
}));
exports.FineTuneModelsButton = FineTuneModelsButton;
const DeployModel = ({
  dismiss,
  ingestionMethod,
  isCreateButtonDisabled,
  isDismissable
}) => {
  const {
    createTextExpansionModel
  } = (0, _kea.useActions)(_text_expansion_callout_logic.TextExpansionCalloutLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.titleBadge",
    defaultMessage: "New"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.title', {
    defaultMessage: 'Improve your results with ELSER'
  })))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(TextExpansionDismissButton, {
    dismiss: dismiss
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedHTMLMessage, {
    id: "xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.body",
    defaultMessage: "ELSER (Elastic Learned Sparse EncodeR) is our <strong>new trained machine learning model</strong> designed to efficiently use context in natural language queries. This model delivers better results than BM25 without further training on your data.",
    tagName: "p"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-textExpansionCallOut-deployModel`,
    disabled: isCreateButtonDisabled,
    iconType: "launch",
    onClick: () => createTextExpansionModel(undefined)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCallOut.deployButton.label', {
    defaultMessage: 'Deploy'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.elser
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.learnMoreLink",
    defaultMessage: "Learn more"
  })))))))));
};
exports.DeployModel = DeployModel;
const ModelDeploymentInProgress = ({
  dismiss,
  isDismissable
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "success"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  color: "success",
  type: "clock"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "success",
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.deployingTitle', {
  defaultMessage: 'Your ELSER model is deploying.'
})))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(TextExpansionDismissButton, {
  dismiss: dismiss
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.deployingBody', {
  defaultMessage: 'You can continue creating your pipeline with other uploaded models in the meantime.'
}))))));
exports.ModelDeploymentInProgress = ModelDeploymentInProgress;
const ModelDeployed = ({
  dismiss,
  ingestionMethod,
  isDismissable,
  isStartButtonDisabled
}) => {
  const {
    startTextExpansionModel
  } = (0, _kea.useActions)(_text_expansion_callout_logic.TextExpansionCalloutLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "success",
    type: "checkInCircleFilled"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.deployedTitle', {
    defaultMessage: 'Your ELSER model has deployed but not started.'
  })))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(TextExpansionDismissButton, {
    dismiss: dismiss
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.deployedBody', {
    defaultMessage: 'You may start the model in a single-threaded configuration for testing, or tune the performance for a production environment.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-textExpansionCallOut-startModel`,
    disabled: isStartButtonDisabled,
    iconType: "playFilled",
    onClick: () => startTextExpansionModel(undefined)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCallOut.startModelButton.label', {
    defaultMessage: 'Start single-threaded'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(FineTuneModelsButton, null))))));
};
exports.ModelDeployed = ModelDeployed;
const ModelStarted = ({
  dismiss,
  isCompact,
  isDismissable,
  isSingleThreaded
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "success"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "checkInCircleFilled",
  color: "success"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "success",
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h3", null, isSingleThreaded ? isCompact ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedSingleThreadedTitleCompact', {
  defaultMessage: 'Your ELSER model is running single-threaded.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedSingleThreadedTitle', {
  defaultMessage: 'Your ELSER model has started single-threaded.'
}) : isCompact ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedTitleCompact', {
  defaultMessage: 'Your ELSER model is running.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedTitle', {
  defaultMessage: 'Your ELSER model has started.'
})))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(TextExpansionDismissButton, {
  dismiss: dismiss
})))), !isCompact && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, isSingleThreaded ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedSingleThreadedBody', {
  defaultMessage: 'This single-threaded configuration is great for testing your custom inference pipelines, however performance should be fine-tuned for production.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.startedBody', {
  defaultMessage: 'Enjoy the power of ELSER in your custom Inference pipeline.'
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "m",
  alignItems: "center",
  justifyContent: "flexStart"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, isSingleThreaded ? /*#__PURE__*/_react.default.createElement(FineTuneModelsButton, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconSide: "left",
  iconType: "wrench",
  onClick: () => _kibana.KibanaLogic.values.navigateToUrl(TRAINED_MODELS_PATH, {
    shouldNotCreateHref: true
  })
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCallOut.viewModelsButton', {
  defaultMessage: 'View details'
}))))))));
exports.ModelStarted = ModelStarted;
const TextExpansionCallOut = props => {
  const {
    dismiss,
    isCompact,
    isDismissable,
    show
  } = (0, _text_expansion_callout_data.useTextExpansionCallOutData)(props);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    createTextExpansionModelError,
    fetchTextExpansionModelError,
    isCreateButtonDisabled,
    isModelDownloadInProgress,
    isModelDownloaded,
    isModelRunningSingleThreaded,
    isModelStarted,
    isStartButtonDisabled,
    startTextExpansionModelError
  } = (0, _kea.useValues)(_text_expansion_callout_logic.TextExpansionCalloutLogic);

  // In case of an error, show the error callout only
  const error = (0, _text_expansion_callout_logic.getTextExpansionError)(createTextExpansionModelError, fetchTextExpansionModelError, startTextExpansionModelError);
  if (error) return /*#__PURE__*/_react.default.createElement(_text_expansion_errors.TextExpansionErrors, {
    error: error
  });
  if (!show) return null;
  if (isModelDownloadInProgress) {
    return /*#__PURE__*/_react.default.createElement(ModelDeploymentInProgress, {
      dismiss: dismiss,
      isDismissable: isDismissable
    });
  } else if (isModelDownloaded) {
    return /*#__PURE__*/_react.default.createElement(ModelDeployed, {
      dismiss: dismiss,
      ingestionMethod: ingestionMethod,
      isDismissable: isDismissable,
      isStartButtonDisabled: isStartButtonDisabled
    });
  } else if (isModelStarted) {
    return /*#__PURE__*/_react.default.createElement(ModelStarted, {
      dismiss: dismiss,
      isCompact: isCompact,
      isDismissable: isDismissable,
      isSingleThreaded: isModelRunningSingleThreaded
    });
  }
  return /*#__PURE__*/_react.default.createElement(DeployModel, {
    dismiss: dismiss,
    ingestionMethod: ingestionMethod,
    isDismissable: isDismissable,
    isCreateButtonDisabled: isCreateButtonDisabled
  });
};
exports.TextExpansionCallOut = TextExpansionCallOut;