"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlModelSelectOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ml_inference_pipeline = require("../../../../../../../common/ml_inference_pipeline");
var _utils = require("../../../shared/ml_inference/utils");
var _ml_model_health = require("../ml_model_health");
var _ml_model_type_badge = require("../ml_model_type_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlModelSelectOption = ({
  model
}) => {
  const type = (0, _utils.getMLType)((0, _ml_inference_pipeline.getMlModelTypesForModelConfig)(model));
  const title = (0, _utils.getModelDisplayTitle)(type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title !== null && title !== void 0 ? title : model.model_id))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, model.model_id)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ml_model_health.TrainedModelHealth, {
    modelState: (0, _ml_inference_pipeline.parseModelStateFromStats)(model),
    modelStateReason: (0, _ml_inference_pipeline.parseModelStateReasonFromStats)(model)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ml_model_type_badge.MLModelTypeBadge, {
    type: type
  })))))));
};
exports.MlModelSelectOption = MlModelSelectOption;