"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLInferenceLogic = exports.EMPTY_PIPELINE_CONFIGURATION = void 0;
var _kea = require("kea");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _ml_inference_pipeline = require("../../../../../../../common/ml_inference_pipeline");
var _api = require("../../../../../../../common/types/api");
var _handle_api_errors = require("../../../../../shared/flash_messages/handle_api_errors");
var _cached_fetch_index_api_logic = require("../../../../api/index/cached_fetch_index_api_logic");
var _mappings_logic = require("../../../../api/mappings/mappings_logic");
var _ml_trained_models_logic = require("../../../../api/ml_models/ml_trained_models_logic");
var _start_text_expansion_model_api_logic = require("../../../../api/ml_models/text_expansion/start_text_expansion_model_api_logic");
var _attach_ml_inference_pipeline = require("../../../../api/pipelines/attach_ml_inference_pipeline");
var _create_ml_inference_pipeline = require("../../../../api/pipelines/create_ml_inference_pipeline");
var _fetch_ml_inference_pipeline_processors = require("../../../../api/pipelines/fetch_ml_inference_pipeline_processors");
var _fetch_ml_inference_pipelines = require("../../../../api/pipelines/fetch_ml_inference_pipelines");
var _fetch_pipeline = require("../../../../api/pipelines/fetch_pipeline");
var _indices = require("../../../../utils/indices");
var _utils = require("../../../shared/ml_inference/utils");
var _pipelines_logic = require("../pipelines_logic");
var _types = require("./types");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_PIPELINE_CONFIGURATION = {
  destinationField: '',
  modelID: '',
  pipelineName: '',
  sourceField: ''
};
exports.EMPTY_PIPELINE_CONFIGURATION = EMPTY_PIPELINE_CONFIGURATION;
const isNotTextExpansionModel = model => {
  return model.modelType !== _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EXPANSION;
};
const API_REQUEST_COMPLETE_STATUSES = [_api.Status.SUCCESS, _api.Status.ERROR];
const DEFAULT_CONNECTOR_FIELDS = ['body', 'title', 'id', 'type', 'url'];
const MLInferenceLogic = (0, _kea.kea)({
  actions: {
    addSelectedFieldsToMapping: true,
    attachPipeline: true,
    clearFormErrors: true,
    createPipeline: true,
    onAddInferencePipelineStepChange: step => ({
      step
    }),
    removeFieldFromMapping: fieldName => ({
      fieldName
    }),
    selectExistingPipeline: pipelineName => ({
      pipelineName
    }),
    selectFields: fieldNames => ({
      fieldNames
    }),
    setAddInferencePipelineStep: step => ({
      step
    }),
    setFormErrors: inputErrors => ({
      inputErrors
    }),
    setIndexName: indexName => ({
      indexName
    }),
    setInferencePipelineConfiguration: configuration => ({
      configuration
    })
  },
  connect: {
    actions: [_fetch_ml_inference_pipelines.FetchMlInferencePipelinesApiLogic, ['makeRequest as makeMlInferencePipelinesRequest', 'apiSuccess as mlInferencePipelinesSuccess'], _mappings_logic.MappingsApiLogic, ['makeRequest as makeMappingRequest', 'apiError as mappingsApiError'], _ml_trained_models_logic.TrainedModelsApiLogic, ['makeRequest as makeMLModelsRequest', 'apiError as mlModelsApiError'], _create_ml_inference_pipeline.CreateMlInferencePipelineApiLogic, ['apiError as createApiError', 'apiSuccess as createApiSuccess', 'makeRequest as makeCreatePipelineRequest'], _attach_ml_inference_pipeline.AttachMlInferencePipelineApiLogic, ['apiError as attachApiError', 'apiSuccess as attachApiSuccess', 'makeRequest as makeAttachPipelineRequest'], _pipelines_logic.PipelinesLogic, ['closeAddMlInferencePipelineModal as closeAddMlInferencePipelineModal'], _start_text_expansion_model_api_logic.StartTextExpansionModelApiLogic, ['apiSuccess as startTextExpansionModelSuccess'], _fetch_pipeline.FetchPipelineApiLogic, ['apiReset as clearFetchedPipeline', 'makeRequest as fetchPipelineByName', 'apiSuccess as fetchPipelineSuccess']],
    values: [_cached_fetch_index_api_logic.CachedFetchIndexApiLogic, ['indexData as index'], _fetch_ml_inference_pipelines.FetchMlInferencePipelinesApiLogic, ['data as mlInferencePipelinesData'], _mappings_logic.MappingsApiLogic, ['data as mappingData', 'status as mappingStatus'], _ml_trained_models_logic.TrainedModelsApiLogic, ['data as mlModelsData', 'status as mlModelsStatus'], _fetch_ml_inference_pipeline_processors.FetchMlInferencePipelineProcessorsApiLogic, ['data as mlInferencePipelineProcessors'], _fetch_pipeline.FetchPipelineApiLogic, ['data as existingPipeline']]
  },
  events: {},
  listeners: ({
    values,
    actions
  }) => ({
    attachPipeline: () => {
      const {
        addInferencePipelineModal: {
          configuration: {
            pipelineName
          },
          indexName
        }
      } = values;
      actions.makeAttachPipelineRequest({
        indexName,
        pipelineName
      });
    },
    createPipeline: () => {
      const {
        addInferencePipelineModal: {
          configuration,
          indexName
        },
        isTextExpansionModelSelected,
        mlInferencePipeline // Full pipeline definition
      } = values;
      actions.makeCreatePipelineRequest(isTextExpansionModelSelected && mlInferencePipeline && configuration.fieldMappings ? {
        indexName,
        fieldMappings: configuration.fieldMappings,
        pipelineDefinition: mlInferencePipeline,
        pipelineName: configuration.pipelineName
      } : {
        destinationField: configuration.destinationField.trim().length > 0 ? configuration.destinationField : undefined,
        indexName,
        inferenceConfig: configuration.inferenceConfig,
        modelId: configuration.modelID,
        pipelineName: configuration.pipelineName,
        sourceField: configuration.sourceField
      });
    },
    selectExistingPipeline: ({
      pipelineName
    }) => {
      var _values$mlInferencePi, _params$destination_f;
      const pipeline = (_values$mlInferencePi = values.mlInferencePipelinesData) === null || _values$mlInferencePi === void 0 ? void 0 : _values$mlInferencePi[pipelineName];
      if (!pipeline) return;
      const params = (0, _ml_inference_pipeline.parseMlInferenceParametersFromPipeline)(pipelineName, pipeline);
      if (params === null) return;
      actions.setInferencePipelineConfiguration({
        destinationField: (_params$destination_f = params.destination_field) !== null && _params$destination_f !== void 0 ? _params$destination_f : '',
        existingPipeline: true,
        modelID: params.model_id,
        pipelineName,
        sourceField: params.source_field
      });
    },
    setIndexName: ({
      indexName
    }) => {
      actions.makeMlInferencePipelinesRequest(undefined);
      actions.makeMLModelsRequest(undefined);
      actions.makeMappingRequest({
        indexName
      });
    },
    mlInferencePipelinesSuccess: data => {
      var _data$length;
      if (((_data$length = data === null || data === void 0 ? void 0 : data.length) !== null && _data$length !== void 0 ? _data$length : 0) === 0 && values.addInferencePipelineModal.configuration.existingPipeline === undefined) {
        // Default to a new pipeline if there are no existing pipelines to choose
        actions.setInferencePipelineConfiguration({
          ...values.addInferencePipelineModal.configuration,
          existingPipeline: false
        });
      }
    },
    startTextExpansionModelSuccess: () => {
      // Refresh ML models list when the text expansion model is started
      actions.makeMLModelsRequest(undefined);
    },
    onAddInferencePipelineStepChange: ({
      step
    }) => {
      const {
        addInferencePipelineModal: {
          configuration: {
            pipelineName,
            existingPipeline
          },
          step: currentStep
        }
      } = values;
      if (currentStep === _types.AddInferencePipelineSteps.Configuration && !existingPipeline) {
        // Validate name is not in use
        actions.fetchPipelineByName({
          pipelineName: `ml-inference-${(0, _ml_inference_pipeline.formatPipelineName)(pipelineName)}`
        });
        // Continue to the next step so we don't have to save it to state, we will change
        // back to the Configuration step if we find a pipeline with the same name
      }

      actions.setAddInferencePipelineStep(step);
    },
    fetchPipelineSuccess: () => {
      // We found a pipeline with the name go back to configuration step
      actions.setAddInferencePipelineStep(_types.AddInferencePipelineSteps.Configuration);
    }
  }),
  path: ['enterprise_search', 'content', 'pipelines_add_ml_inference_pipeline'],
  reducers: {
    addInferencePipelineModal: [{
      configuration: {
        ...EMPTY_PIPELINE_CONFIGURATION
      },
      indexName: '',
      step: _types.AddInferencePipelineSteps.Configuration
    }, {
      addSelectedFieldsToMapping: modal => {
        const {
          configuration: {
            fieldMappings
          },
          selectedSourceFields
        } = modal;
        const mergedFieldMappings = [...(fieldMappings || []), ...(selectedSourceFields || []).map(fieldName => ({
          sourceField: fieldName,
          targetField: (0, _ml_inference_pipeline.getMlInferencePrefixedFieldName)(`${fieldName}_expanded`)
        }))];
        return {
          ...modal,
          configuration: {
            ...modal.configuration,
            fieldMappings: mergedFieldMappings
          },
          selectedSourceFields: []
        };
      },
      closeAddMlInferencePipelineModal: () => ({
        configuration: {
          ...EMPTY_PIPELINE_CONFIGURATION
        },
        indexName: '',
        step: _types.AddInferencePipelineSteps.Configuration
      }),
      createApiSuccess: () => ({
        configuration: {
          ...EMPTY_PIPELINE_CONFIGURATION
        },
        indexName: '',
        step: _types.AddInferencePipelineSteps.Configuration
      }),
      removeFieldFromMapping: (modal, {
        fieldName
      }) => {
        const {
          configuration: {
            fieldMappings
          }
        } = modal;
        if (!fieldMappings) {
          return modal;
        }
        return {
          ...modal,
          configuration: {
            ...modal.configuration,
            fieldMappings: fieldMappings === null || fieldMappings === void 0 ? void 0 : fieldMappings.filter(({
              sourceField
            }) => sourceField !== fieldName)
          }
        };
      },
      selectFields: (modal, {
        fieldNames
      }) => ({
        ...modal,
        configuration: {
          ...modal.configuration
        },
        selectedSourceFields: fieldNames
      }),
      setAddInferencePipelineStep: (modal, {
        step
      }) => ({
        ...modal,
        step
      }),
      setIndexName: (modal, {
        indexName
      }) => ({
        ...modal,
        indexName
      }),
      setInferencePipelineConfiguration: (modal, {
        configuration
      }) => ({
        ...modal,
        configuration
      })
    }],
    createErrors: [[], {
      attachApiError: (_, error) => (0, _handle_api_errors.getErrorsFromHttpResponse)(error),
      createApiError: (_, error) => (0, _handle_api_errors.getErrorsFromHttpResponse)(error),
      makeAttachPipelineRequest: () => [],
      makeCreatePipelineRequest: () => []
    }]
  },
  selectors: ({
    selectors
  }) => ({
    formErrors: [() => [selectors.addInferencePipelineModal, selectors.existingPipeline], (modal, existingPipeline) => ({
      ...(0, _utils2.validateInferencePipelineConfiguration)(modal.configuration),
      ...(0, _utils2.validateInferencePipelineFields)(modal.configuration),
      ...(0, _utils2.validatePipelineNameIsAvailable)(existingPipeline)
    })],
    isConfigureStepValid: [() => [selectors.addInferencePipelineModal], modal => {
      const errors = (0, _utils2.validateInferencePipelineConfiguration)(modal.configuration);
      return Object.keys(errors).length === 0;
    }],
    isLoading: [() => [selectors.mlModelsStatus, selectors.mappingStatus], (mlModelsStatus, mappingStatus) => !API_REQUEST_COMPLETE_STATUSES.includes(mlModelsStatus) || !API_REQUEST_COMPLETE_STATUSES.includes(mappingStatus)],
    isPipelineDataValid: [() => [selectors.formErrors], errors => Object.keys(errors).length === 0],
    isTextExpansionModelSelected: [() => [selectors.selectedMLModel], model => {
      var _model$inference_conf;
      return !!(model !== null && model !== void 0 && (_model$inference_conf = model.inference_config) !== null && _model$inference_conf !== void 0 && _model$inference_conf.text_expansion);
    }],
    mlInferencePipeline: [() => [selectors.isPipelineDataValid, selectors.addInferencePipelineModal, selectors.mlModelsData, selectors.mlInferencePipelinesData], (isPipelineDataValid, {
      configuration
    }, models, mlInferencePipelinesData) => {
      if (configuration.existingPipeline) {
        if (configuration.pipelineName.length === 0) {
          return undefined;
        }
        const pipeline = mlInferencePipelinesData === null || mlInferencePipelinesData === void 0 ? void 0 : mlInferencePipelinesData[configuration.pipelineName];
        if (!pipeline) {
          return undefined;
        }
        return pipeline;
      }
      if (!isPipelineDataValid) return undefined;
      const model = models === null || models === void 0 ? void 0 : models.find(mlModel => mlModel.model_id === configuration.modelID);
      if (!model) return undefined;
      return (0, _ml_inference_pipeline.generateMlInferencePipelineBody)({
        model,
        pipelineName: configuration.pipelineName,
        fieldMappings: configuration.fieldMappings || [{
          sourceField: configuration.sourceField,
          targetField: configuration.destinationField || (0, _ml_inference_pipeline.formatPipelineName)(configuration.pipelineName)
        }],
        inferenceConfig: configuration.inferenceConfig
      });
    }],
    sourceFields: [() => [selectors.mappingStatus, selectors.mappingData, selectors.index], (status, mapping, index) => {
      var _mapping$mappings;
      if (status !== _api.Status.SUCCESS) return;
      if ((mapping === null || mapping === void 0 ? void 0 : (_mapping$mappings = mapping.mappings) === null || _mapping$mappings === void 0 ? void 0 : _mapping$mappings.properties) === undefined) {
        if ((0, _indices.isConnectorIndex)(index)) {
          return DEFAULT_CONNECTOR_FIELDS;
        }
        return [];
      }
      return Object.entries(mapping.mappings.properties).reduce((fields, [key, value]) => {
        if (value.type === 'text' || value.type === 'keyword') {
          fields.push(key);
        }
        return fields;
      }, []).sort(_utils.sortSourceFields);
    }],
    supportedMLModels: [() => [selectors.mlModelsData], mlModelsData => {
      var _mlModelsData$filter;
      return ((_mlModelsData$filter = mlModelsData === null || mlModelsData === void 0 ? void 0 : mlModelsData.filter(_utils.isSupportedMLModel)) !== null && _mlModelsData$filter !== void 0 ? _mlModelsData$filter : []).sort(_utils.sortModels);
    }],
    existingInferencePipelines: [() => [selectors.mlInferencePipelinesData, selectors.sourceFields, selectors.supportedMLModels, selectors.mlInferencePipelineProcessors], (mlInferencePipelinesData, sourceFields, supportedMLModels, mlInferencePipelineProcessors) => {
      var _mlInferencePipelineP;
      if (!mlInferencePipelinesData) {
        return [];
      }
      const indexProcessorNames = (_mlInferencePipelineP = mlInferencePipelineProcessors === null || mlInferencePipelineProcessors === void 0 ? void 0 : mlInferencePipelineProcessors.map(processor => processor.pipelineName)) !== null && _mlInferencePipelineP !== void 0 ? _mlInferencePipelineP : [];
      const existingPipelines = Object.entries(mlInferencePipelinesData).map(([pipelineName, pipeline]) => {
        if (!pipeline) return undefined;
        const pipelineParams = (0, _ml_inference_pipeline.parseMlInferenceParametersFromPipeline)(pipelineName, pipeline);
        if (!pipelineParams) return undefined;
        const {
          destination_field: destinationField,
          model_id: modelId,
          source_field: sourceField
        } = pipelineParams;
        const mlModel = supportedMLModels.find(model => model.model_id === modelId);
        const modelType = mlModel ? (0, _utils.getMLType)((0, _ml_inference_pipeline.getMlModelTypesForModelConfig)(mlModel)) : '';
        const disabledReason = (0, _utils2.getDisabledReason)(sourceFields, sourceField, indexProcessorNames, pipelineName, modelType);
        return {
          destinationField: destinationField !== null && destinationField !== void 0 ? destinationField : '',
          disabled: disabledReason !== undefined,
          disabledReason,
          modelId,
          modelType,
          pipelineName,
          sourceField
        };
      }).filter(p => p !== undefined && isNotTextExpansionModel(p));
      return existingPipelines;
    }],
    selectedMLModel: [() => [selectors.supportedMLModels, selectors.addInferencePipelineModal], (supportedMLModels, addInferencePipelineModal) => {
      var _supportedMLModels$fi;
      return (_supportedMLModels$fi = supportedMLModels.find(model => model.model_id === addInferencePipelineModal.configuration.modelID)) !== null && _supportedMLModels$fi !== void 0 ? _supportedMLModels$fi : null;
    }]
  })
});
exports.MLInferenceLogic = MLInferenceLogic;