"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurePipeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../../shared/doc_links");
var _index_view_logic = require("../../index_view_logic");
var _inference_config = require("./inference_config");
var _ml_inference_logic = require("./ml_inference_logic");
var _model_select_option = require("./model_select_option");
var _pipeline_select_option = require("./pipeline_select_option");
var _text_expansion_callout = require("./text_expansion_callout");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MODEL_SELECT_PLACEHOLDER_VALUE = 'model_placeholder$$';
const PIPELINE_SELECT_PLACEHOLDER_VALUE = 'pipeline_placeholder$$';
const CHOOSE_EXISTING_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipeline.chooseLabel', {
  defaultMessage: 'Choose'
});
const CHOOSE_NEW_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipeline.newLabel', {
  defaultMessage: 'New pipeline'
});
const CHOOSE_PIPELINE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipeline.existingLabel', {
  defaultMessage: 'Existing pipeline'
});
const ConfigurePipeline = () => {
  var _existingInferencePip, _configuration$existi, _configuration$existi2;
  const {
    addInferencePipelineModal: {
      configuration
    },
    formErrors,
    existingInferencePipelines,
    supportedMLModels
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    selectExistingPipeline,
    setInferencePipelineConfiguration
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    existingPipeline,
    modelID,
    pipelineName
  } = configuration;
  const nameError = formErrors.pipelineName !== undefined && pipelineName.length > 0;
  const modelOptions = [{
    disabled: true,
    inputDisplay: existingPipeline && pipelineName.length > 0 ? _utils.MODEL_REDACTED_VALUE : _utils.MODEL_SELECT_PLACEHOLDER,
    value: MODEL_SELECT_PLACEHOLDER_VALUE
  }, ...supportedMLModels.map(model => ({
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_model_select_option.MlModelSelectOption, {
      model: model
    }),
    inputDisplay: model.model_id,
    value: model.model_id
  }))];
  const pipelineOptions = [{
    disabled: true,
    inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipeline.placeholder', {
      defaultMessage: 'Select one'
    }),
    value: PIPELINE_SELECT_PLACEHOLDER_VALUE
  }, ...((_existingInferencePip = existingInferencePipelines === null || existingInferencePipelines === void 0 ? void 0 : existingInferencePipelines.map(pipeline => ({
    disabled: pipeline.disabled,
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_pipeline_select_option.PipelineSelectOption, {
      pipeline: pipeline
    }),
    inputDisplay: pipeline.pipelineName,
    value: pipeline.pipelineName
  }))) !== null && _existingInferencePip !== void 0 ? _existingInferencePip : [])];
  const inputsDisabled = configuration.existingPipeline !== false;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.title', {
    defaultMessage: 'Create or select a pipeline'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.description', {
    defaultMessage: 'Build or reuse a child pipeline that will be used as a processor in your main pipeline.'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionUsePipelines', {
    defaultMessage: 'Pipelines you create will be saved to be used elsewhere in your Elastic deployment.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.chooseExistingLabel', {
      defaultMessage: 'New or existing'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    options: [{
      disabled: true,
      text: CHOOSE_EXISTING_LABEL,
      value: ''
    }, {
      text: CHOOSE_NEW_LABEL,
      value: 'false'
    }, {
      disabled: !existingInferencePipelines || existingInferencePipelines.length === 0,
      text: CHOOSE_PIPELINE_LABEL,
      value: 'true'
    }],
    onChange: e => setInferencePipelineConfiguration({
      ..._ml_inference_logic.EMPTY_PIPELINE_CONFIGURATION,
      existingPipeline: e.target.value === 'true'
    }),
    value: (_configuration$existi = (_configuration$existi2 = configuration.existingPipeline) === null || _configuration$existi2 === void 0 ? void 0 : _configuration$existi2.toString()) !== null && _configuration$existi !== void 0 ? _configuration$existi : ''
  })), configuration.existingPipeline === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipelineLabel', {
      defaultMessage: 'Select an existing inference pipeline'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    hasDividers: true,
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-selectExistingPipeline`,
    valueOfSelected: pipelineName.length > 0 ? pipelineName : PIPELINE_SELECT_PLACEHOLDER_VALUE,
    options: pipelineOptions,
    onChange: value => selectExistingPipeline(value)
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.nameLabel', {
      defaultMessage: 'Name'
    }),
    helpText: !nameError && configuration.existingPipeline === false && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.name.helpText', {
      defaultMessage: 'Pipeline names are unique within a deployment and can only contain letters, numbers, underscores, and hyphens. This will create a pipeline named {pipelineName}.',
      values: {
        pipelineName: `ml-inference-${pipelineName.length > 0 ? pipelineName : '<name>'}`
      }
    })),
    error: nameError && formErrors.pipelineName,
    isInvalid: nameError
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-uniqueName`,
    disabled: inputsDisabled,
    fullWidth: true,
    prepend: "ml-inference-",
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.namePlaceholder', {
      defaultMessage: 'Enter a unique name for this pipeline'
    }),
    value: pipelineName,
    onChange: e => setInferencePipelineConfiguration({
      ...configuration,
      pipelineName: e.target.value
    })
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.titleSelectTrainedModel', {
    defaultMessage: 'Select a trained ML Model'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionDeployTrainedModel', {
    defaultMessage: 'To perform natural language processing tasks in your cluster, you must deploy an appropriate trained model.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.deployTrainedModels,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.docsLink', {
    defaultMessage: 'Learn more about importing and using ML models in Enterprise Search'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.modelLabel', {
      defaultMessage: 'Select a trained ML Model'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-selectTrainedModel`,
    fullWidth: true,
    hasDividers: true,
    disabled: inputsDisabled,
    itemLayoutAlign: "top",
    onChange: value => setInferencePipelineConfiguration({
      ...configuration,
      inferenceConfig: undefined,
      modelID: value,
      fieldMappings: undefined
    }),
    options: modelOptions,
    valueOfSelected: modelID === '' ? MODEL_SELECT_PLACEHOLDER_VALUE : modelID
  })), /*#__PURE__*/_react.default.createElement(_inference_config.InferenceConfiguration, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_text_expansion_callout.TextExpansionCallOut, {
    isCompact: true
  })))));
};
exports.ConfigurePipeline = ConfigurePipeline;