"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceHistory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _data_panel = require("../../../../shared/data_panel/data_panel");
var _inference_history_logic = require("./inference_history_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceHistory = () => {
  const {
    indexName,
    isLoading,
    inferenceHistory
  } = (0, _kea.useValues)(_inference_history_logic.InferenceHistoryLogic);
  const {
    fetchIndexInferenceHistory
  } = (0, _kea.useActions)(_inference_history_logic.InferenceHistoryLogic);
  (0, _react.useEffect)(() => {
    fetchIndexInferenceHistory({
      indexName
    });
  }, [indexName]);
  const historyColumns = [{
    dataType: 'string',
    field: 'pipeline',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.tableColumn.pipeline', {
      defaultMessage: 'Inference pipeline'
    })
  }, {
    dataType: 'number',
    field: 'doc_count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.tableColumn.docCount', {
      defaultMessage: 'Approx. document count'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    iconType: "compute",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.title', {
      defaultMessage: 'Historical inference processors'
    })),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.subtitle', {
      defaultMessage: 'The following inference processors were found in the _ingest.processors field of documents on this index.'
    })
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: historyColumns,
    items: inferenceHistory !== null && inferenceHistory !== void 0 ? inferenceHistory : [],
    rowHeader: "pipeline",
    noItemsMessage: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.emptyMessage', {
      defaultMessage: 'This index has no inference history'
    })
  })));
};
exports.InferenceHistory = InferenceHistory;