"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceErrorsLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../common/types/api");
var _fetch_ml_inference_pipeline_errors = require("../../../api/pipelines/fetch_ml_inference_pipeline_errors");
var _index_name_logic = require("../index_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceErrorsLogic = (0, _kea.kea)({
  connect: {
    values: [_index_name_logic.IndexNameLogic, ['indexName'], _fetch_ml_inference_pipeline_errors.FetchMlInferenceErrorsApiLogic, ['data as inferenceErrorsData', 'status as fetchIndexInferenceHistoryStatus']]
  },
  path: ['enterprise_search', 'content', 'pipelines_inference_errors'],
  selectors: ({
    selectors
  }) => ({
    inferenceErrors: [() => [selectors.inferenceErrorsData], inferenceErrorsData => {
      var _inferenceErrorsData$;
      return (_inferenceErrorsData$ = inferenceErrorsData === null || inferenceErrorsData === void 0 ? void 0 : inferenceErrorsData.errors) !== null && _inferenceErrorsData$ !== void 0 ? _inferenceErrorsData$ : [];
    }],
    isLoading: [() => [selectors.fetchIndexInferenceHistoryStatus], fetchIndexInferenceHistoryStatus => fetchIndexInferenceHistoryStatus !== _api.Status.SUCCESS && fetchIndexInferenceHistoryStatus !== _api.Status.ERROR]
  })
});
exports.InferenceErrorsLogic = InferenceErrorsLogic;