"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _indices = require("../../utils/indices");
var _api_total_stats = require("./api_total_stats");
var _connector_total_stats = require("./connector_total_stats");
var _crawl_details_flyout = require("./crawler/crawl_details_flyout/crawl_details_flyout");
var _crawl_requests_panel = require("./crawler/crawl_requests_panel/crawl_requests_panel");
var _crawler_total_stats = require("./crawler_total_stats");
var _generate_api_key_panel = require("./generate_api_key_panel");
var _index_view_logic = require("./index_view_logic");
var _overview = require("./overview.logic");
var _sync_jobs = require("./sync_jobs/sync_jobs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexOverview = () => {
  const {
    indexData
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const {
    error
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), (0, _indices.isConnectorIndex)(indexData) && error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.connectorErrorCallOut.title', {
      defaultMessage: 'Your connector has reported an error'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), (0, _indices.isCrawlerIndex)(indexData) ? /*#__PURE__*/_react.default.createElement(_crawler_total_stats.CrawlerTotalStats, null) : (0, _indices.isConnectorIndex)(indexData) ? /*#__PURE__*/_react.default.createElement(_connector_total_stats.ConnectorTotalStats, null) : /*#__PURE__*/_react.default.createElement(_api_total_stats.ApiTotalStats, null), (0, _indices.isApiIndex)(indexData) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_generate_api_key_panel.GenerateApiKeyPanel, null)), (0, _indices.isCrawlerIndex)(indexData) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_requests_panel.CrawlRequestsPanel, null), /*#__PURE__*/_react.default.createElement(_crawl_details_flyout.CrawlDetailsFlyout, null)), (0, _indices.isConnectorIndex)(indexData) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sync_jobs.SyncJobs, null)));
};
exports.SearchIndexOverview = SearchIndexOverview;