"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertMetaToPagination = exports.INDEX_DOCUMENTS_META_DEFAULT = exports.DocumentsLogic = exports.DEFAULT_PAGINATION = void 0;
var _kea = require("kea");
var _constants = require("../../../../../common/constants");
var _api = require("../../../../../common/types/api");
var _table_pagination = require("../../../shared/table_pagination");
var _mappings_logic = require("../../api/mappings/mappings_logic");
var _search_documents_api_logic = require("../../api/search_documents/search_documents_api_logic");
var _index_name_logic = require("./index_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_DOCUMENTS_META_DEFAULT = {
  page: {
    current: 0,
    size: _constants.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT,
    total_pages: 0,
    total_results: 0
  }
};
exports.INDEX_DOCUMENTS_META_DEFAULT = INDEX_DOCUMENTS_META_DEFAULT;
const DEFAULT_PAGINATION = {
  pageIndex: INDEX_DOCUMENTS_META_DEFAULT.page.current,
  pageSize: INDEX_DOCUMENTS_META_DEFAULT.page.size,
  totalItemCount: INDEX_DOCUMENTS_META_DEFAULT.page.total_results
};
exports.DEFAULT_PAGINATION = DEFAULT_PAGINATION;
const convertMetaToPagination = meta => ({
  pageIndex: meta.page.current,
  pageSize: meta.page.size,
  totalItemCount: meta.page.total_results
});
exports.convertMetaToPagination = convertMetaToPagination;
const DocumentsLogic = (0, _kea.kea)({
  actions: {
    onPaginate: newPageIndex => ({
      newPageIndex
    }),
    setDocsPerPage: docsPerPage => ({
      docsPerPage
    }),
    setSearchQuery: query => ({
      query
    })
  },
  connect: {
    actions: [_search_documents_api_logic.SearchDocumentsApiLogic, ['apiReset', 'apiSuccess', 'makeRequest'], _mappings_logic.MappingsApiLogic, ['makeRequest as makeMappingRequest']],
    values: [_search_documents_api_logic.SearchDocumentsApiLogic, ['data', 'status'], _mappings_logic.MappingsApiLogic, ['data as mappingData', 'status as mappingStatus'], _index_name_logic.IndexNameLogic, ['indexName']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    onPaginate: () => {
      actions.makeRequest({
        docsPerPage: values.docsPerPage,
        indexName: values.indexName,
        pagination: convertMetaToPagination(values.meta),
        query: values.query
      });
    },
    setDocsPerPage: () => {
      actions.makeRequest({
        docsPerPage: values.docsPerPage,
        indexName: values.indexName,
        pagination: convertMetaToPagination(values.meta),
        query: values.query
      });
    },
    setSearchQuery: async (_, breakpoint) => {
      await breakpoint(250);
      actions.makeRequest({
        docsPerPage: values.docsPerPage,
        indexName: values.indexName,
        pagination: convertMetaToPagination(values.meta),
        query: values.query
      });
    }
  }),
  path: ['enterprise_search', 'search_index', 'documents'],
  reducers: () => ({
    docsPerPage: [_constants.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT, {
      setDocsPerPage: (_, {
        docsPerPage
      }) => docsPerPage
    }],
    meta: [INDEX_DOCUMENTS_META_DEFAULT, {
      apiSuccess: (_, {
        meta
      }) => meta,
      onPaginate: (state, {
        newPageIndex
      }) => (0, _table_pagination.updateMetaPageIndex)(state, newPageIndex),
      setDocsPerPage: (_, {
        docsPerPage
      }) => ({
        page: {
          ...INDEX_DOCUMENTS_META_DEFAULT.page,
          size: docsPerPage
        }
      })
    }],
    query: ['', {
      setSearchQuery: (_, {
        query
      }) => query
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    isLoading: [() => [selectors.status, selectors.mappingStatus], (status, mappingStatus) => status !== _api.Status.SUCCESS || mappingStatus !== _api.Status.SUCCESS],
    results: [() => [selectors.data], data => {
      var _data$results, _data$results$hits;
      return (data === null || data === void 0 ? void 0 : (_data$results = data.results) === null || _data$results === void 0 ? void 0 : (_data$results$hits = _data$results.hits) === null || _data$results$hits === void 0 ? void 0 : _data$results$hits.hits) || [];
    }],
    simplifiedMapping: [() => [selectors.mappingStatus, selectors.mappingData], (status, mapping) => {
      var _mapping$mappings;
      if (status !== _api.Status.SUCCESS) return;
      return mapping === null || mapping === void 0 ? void 0 : (_mapping$mappings = mapping.mappings) === null || _mapping$mappings === void 0 ? void 0 : _mapping$mappings.properties;
    }]
  })
});
exports.DocumentsLogic = DocumentsLogic;