"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexDocuments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _document_list = require("./components/document_list/document_list");
var _documents_logic = require("./documents_logic");
var _index_name_logic = require("./index_name_logic");
require("./documents.scss");
var _index_view_logic = require("./index_view_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexDocuments = () => {
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    simplifiedMapping
  } = (0, _kea.useValues)(_documents_logic.DocumentsLogic);
  const {
    makeRequest,
    makeMappingRequest,
    setSearchQuery
  } = (0, _kea.useActions)(_documents_logic.DocumentsLogic);
  (0, _react.useEffect)(() => {
    makeRequest({
      indexName,
      pagination: _documents_logic.DEFAULT_PAGINATION,
      query: ''
    });
    makeMappingRequest({
      indexName
    });
  }, [indexName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "enterpriseSearchDocumentsHeader",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.title', {
    defaultMessage: 'Browse documents'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-documents-searchDocuments`,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.searchField.placeholder', {
      defaultMessage: 'Search documents in this index'
    }),
    isClearable: true,
    onChange: event => setSearchQuery(event.target.value),
    fullWidth: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !simplifiedMapping && _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.noMappings', {
    defaultMessage: 'No documents found for index'
  }), simplifiedMapping && /*#__PURE__*/_react.default.createElement(_document_list.DocumentList, null))));
};
exports.SearchIndexDocuments = SearchIndexDocuments;